// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_MODULES_PRODUCT_HH
#define DYN_MODULES_PRODUCT_HH

#include <awali/dyn/core/automaton.hh>

namespace awali {
  namespace dyn {

    automaton_t product(automaton_t aut1, automaton_t aut2, bool keep_history=true);
    //automaton_t power(automaton_t aut, unsigned n);
    automaton_t shuffle(automaton_t aut1, automaton_t aut2, bool keep_history=true);
    automaton_t infiltration(automaton_t aut1, automaton_t aut2, bool keep_history=true);
    automaton_t Union(automaton_t aut1, automaton_t aut2);

  }
}//end of ns awali::dyn

#endif
