// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_MODULES_PROPER_HH
#define DYN_MODULES_PROPER_HH

#include <awali/common/direction.hh>
#include <awali/dyn/core/automaton.hh>
#include <awali/dyn/core/abstract-ratexp.hh>

namespace awali { namespace dyn {
  void proper_here(automaton_t aut, param_t dir=param_t::BACKWARD,
                                                          bool prune=true);
  automaton_t proper(automaton_t aut, param_t dir =param_t::BACKWARD,
                                                          bool prune=true);
  bool is_proper(automaton_t aut);
  bool is_valid(automaton_t aut);
  automaton_t allow_eps_transition(automaton_t aut);
  automaton_t thompson(ratexp_t exp);
  automaton_t zpc(ratexp_t exp);
  automaton_t draw_exp(ratexp_t exp);


}}//end of ns awali::dyn

#endif
