// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_MODULES_STANDARD_HH
#define DYN_MODULES_STANDARD_HH

#include <iostream>
#include <unordered_map>
#include <awali/dyn/core/automaton.hh>
#include <awali/dyn/core/abstract-ratexp.hh>
#include <awali/dyn/loading/handler.hh>

namespace awali {
  namespace dyn {

    bool is_standard(automaton_t aut);
    automaton_t standard(automaton_t aut);
    void standard_here(automaton_t aut);
    automaton_t standard(ratexp_t exp);

    automaton_t concatenate(automaton_t aut, automaton_t aut2);
    void concatenate_here(automaton_t aut, automaton_t aut2);

    automaton_t sum(automaton_t aut, automaton_t aut2);
    void sum_here(automaton_t aut, automaton_t aut2);

    automaton_t star(automaton_t aut);
    void star_here(automaton_t aut);

  }
}//end of ns awali::dyn

#endif
