// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_MODULES_TRANSDUCER_HH
#define DYN_MODULES_TRANSDUCER_HH

#include <awali/dyn/modules/automaton.hh>
#include <awali/dyn/modules/proper.hh>

namespace awali {
  namespace dyn {

    //to move in module 'context' for consistency ?
    automaton_t make_transducer(std::vector<std::string> alphabets, std::string semiring);
    automaton_t make_transducer(std::vector<std::string> alphabets);


    unsigned num_tapes (automaton_t tdc);
    transition_t set_tdc_transition (automaton_t tdc, state_t src, state_t dst,
			     const std::vector<std::string>& labels);

    transition_t get_tdc_transition(automaton_t tdc, state_t src, state_t dst,
                                    const std::vector<std::string>& labels);

    bool has_tdc_transition(automaton_t tdc, state_t src, state_t dst,
			    const std::vector<std::string>& labels);

    weight_t add_tdc_transition(automaton_t tdc, state_t src, state_t dst,
				const std::vector<std::string>& labels);

    void del_tdc_transition(automaton_t tdc, state_t src, state_t dst,
			    const std::vector<std::string>& labels);

    transition_t set_tdc_transition(automaton_t tdc, state_t src, state_t dst,
			    const std::vector<std::string>& labels,
			    weight_t w);

    weight_t add_tdc_transition(automaton_t tdc, state_t src, state_t dst,
				const std::vector<std::string>& labels,
				weight_t w);

    std::vector<std::string> get_tdc_label(automaton_t tdc, transition_t tr);

    std::vector<state_t> tdc_successors(automaton_t tdc, state_t s,
					const std::vector<std::string>& label);
    std::vector<state_t> tdc_predecessors(automaton_t tdc, state_t s,
					  const std::vector<std::string>& label);
    std::vector<transition_t> tdc_in(automaton_t tdc, state_t s,
				     const std::vector<std::string>& label);

    std::vector<transition_t> tdc_out(automaton_t tdc, state_t s,
				      const std::vector<std::string>& label);

    std::vector<char> input_alphabet(automaton_t tdc);

    std::vector<char> output_alphabet(automaton_t tdc);

    void set_final_output(automaton_t tdc, state_t src,
			  const std::string& output);

    std::string get_final_output(automaton_t tdc, state_t src);


    std::vector<std::vector<char>> alphabets(automaton_t tdc);

    bool has_label(automaton_t tdc, unsigned i, std::string l);
    bool has_input_label(automaton_t tdc, std::string l);

    bool has_output_label(automaton_t tdc, std::string l);

    automaton_t domain(automaton_t tdc);

    automaton_t image(automaton_t tdc);
    automaton_t images(automaton_t tdc);

    automaton_t projection(automaton_t tdc, unsigned i);

    automaton_t inverse(automaton_t tdc);
    automaton_t compose(automaton_t tdc1, automaton_t tdc2);

    bool is_functional(automaton_t tdc);
    automaton_t lift_tdc(automaton_t tdc);

    bool is_synchronizable(automaton_t tdc);

    automaton_t synchronize(automaton_t tdc);

    automaton_t realtime(automaton_t tdc);

  }
}//end of ns awali::dyn
#endif

