// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#include <awali/dyn.hh>
#include<cassert>

using namespace awali::dyn;

int main() {
  context_description cd = c_desc(ltupleset({nullableset(letterset("ab")),letterset("xy")}), weightset("B"));
  make_automaton_from_context(cd);

  std::vector<std::string> srs{"B", "Z", "Z-min-plus", "Q", "R", "F2"};
  for(auto sr : srs) {
    make_automaton("ab", sr);
    make_automaton_with_eps("ab", sr);
  }

  return 0;
}
