// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#include <awali/dyn.hh>
#include <awali/dyn/loading/locations.hh>
#include <fstream>
#include <cassert>

using namespace awali::dyn;

int main() {
//   std::ifstream file(loading::get_share_directory()+"/automata/a1.json");
  automaton_t aut = load("a1","json");
//   file.close();

  aut=Union(aut, aut);

  std::ofstream out("tmp");
  fado(aut, out);
  out.close();
  std::ifstream file;
  file.open("tmp");
  automaton_t fado_aut = fado(file);
  file.close();

  assert(are_isomorphic(aut,fado_aut));

  out.open("tmp");
  grail(aut, out);
  out.close();
  file.open("tmp");
  automaton_t grail_aut = grail(file);
  file.close();

  assert(are_isomorphic(aut,grail_aut));

  out.open("tmp");
  dot(aut, out);
  out.close();

  return 0;
}
