// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

/* This file is a false header used to centralize the description of the
 * namespaces of Awali. 
 * Used in particular by Doxygen.
 */

/** @brief Main namespace of Awali */
namespace awali {

  /** @brief Namespace for the static layer of Awali. 
   *
   * Automata, rational expressions and algorithms are templated with the context.
   *
   * */
  namespace sttc {

    /** @brief Namespace containing all available contexts (weigh sets, label
     * sets, etc.).  
     */
    namespace ctx { }

    /** @brief Implementation details of static layer (not stable). */
    namespace internal { }



    /** @brief Namespace about static rational expressions. 
     */
    namespace rat { }

  }

  /** @brief Namespace containing facilities to allow one algorithm to be
    * choosen at compile time depending on context, among a sorted list of
    * possibly available functions. 
    */
  namespace priority { }



  /** @brief Namespace for the dynamical layer of Awali.
   *
   * Templates types annotatin automa (among others) have been erased.
   * Each algorithm call an in a given module, possibly compiling it on the fly.
   * */
  namespace dyn {

    /** @brief Implementation details of dyn layer (not stable). */
    namespace internal { }

  }

  /** @brief Namespace containing implementation details of elements common to
    * sttc and dyn layers.
    */
  namespace internal {


  }


  /** @brief Namespace containing the C++ that simplify type for easier to Python. */
  namespace py {

  }


}
