// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef AWALI_ALGOS_FWD_HH
# define AWALI_ALGOS_FWD_HH

# include <memory>

// Beware that this file is dangerous, as it prevents automatic
// instantiation of these algos.  It exists only to solve mutual
// dependencies (e.g.: proper uses is-valid which uses proper).
//
// FIXME: We should probably resolves these issues in some other way.

namespace awali { namespace sttc {

  // sttc/algos/blind.hh
  namespace internal
  {
    template <std::size_t TapeNum, typename Aut>
    class blind_automaton_impl;
  }
  template <std::size_t TapeNum, typename Aut>
  using blind_automaton
    = std::shared_ptr<internal::blind_automaton_impl<TapeNum, Aut>>;

  // sttc/algos/edit-automaton.hh.
  class automaton_editor;

  template <typename Aut>
  bool in_situ_remover(Aut& aut, bool prune=true);

  template <typename Aut>
  bool is_ambiguous(const Aut& aut);

  template <typename Aut>
  bool is_proper(const Aut& aut);

  template <typename Aut>
  bool is_valid(const Aut& aut);

  template <typename RatExpSet>
  bool is_valid(const RatExpSet&, const typename RatExpSet::ratexp_t&);

  namespace detail_info
  {
    template <typename Aut>
    size_t
    num_eps_transitions(const Aut&);
  }

  // sttc/algos/transpose.hh
  namespace internal
  {
    template <typename Aut>
    class transpose_automaton_impl;
  }

  template <typename Aut>
  using transpose_automaton
    = std::shared_ptr<internal::transpose_automaton_impl<Aut>>;

}}//end of ns awali::stc

#endif // !AWALI_ALGOS_FWD_HH
