// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef AWALI_STTC_WAUTOMATON_HH
#define AWALI_STTC_WAUTOMATON_HH
//We work with NFAs (thus the "weight" is Boolean"):
#include <awali/sttc/weightset/b.hh>
//The labels are letters implemented by char:
#include <awali/sttc/ctx/lal_char.hh>
#include <awali/sttc/core/mutable-automaton.hh>

namespace awali {
  namespace sttc {

    template<typename T>
    mutable_automaton<context<ctx::lal_char,T>>
      make_automaton(const std::initializer_list<char>& letters)
    {
      return make_shared_ptr<mutable_automaton<context<ctx::lal_char,T>>>
	(context<ctx::lal_char,T>(ctx::lal_char(letters),T()));
    }

    mutable_automaton<context<ctx::lal_char,b>>
      make_automaton(const std::initializer_list<char>& letters)
    {
      return make_automaton<b>(letters);
    }


  }
}

#endif
