// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef AWALI_CORE_FWD_HH
# define AWALI_CORE_FWD_HH

#include <awali/sttc/misc/memory.hh> // make_shared_ptr.

namespace awali { namespace sttc {


  // sttc/core/crange.hh
  template <class C>
  struct container_range;

  template <class C>
  struct container_filter_range;


  // sttc/core/mutable-automaton.hh
  namespace internal
  {
    template <typename Context>
    class mutable_automaton_impl;
  }
  template <typename Context>
  using mutable_automaton
    = std::shared_ptr<internal::mutable_automaton_impl<Context>>;


  // sttc/core/permutation-automaton.hh.
  namespace internal
  {
    template <typename Aut>
    class permutation_automaton_impl;
  }
  template <typename Aut>
  using permutation_automaton
    = std::shared_ptr<internal::permutation_automaton_impl<Aut>>;


  // sttc/core/ratexp-automaton.hh.
  namespace internal
  {
    template <typename Aut>
    class ratexp_automaton_impl;
  }
  template <typename Aut>
  using ratexp_automaton
    = std::shared_ptr<internal::ratexp_automaton_impl<Aut>>;

}}//end of ns awali::stc

#endif // !AWALI_CORE_FWD_HH
