// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef AWALI_CTX_LAO_BR_HH
# define AWALI_CTX_LAO_BR_HH

#include <awali/sttc/alphabets/char.hh>
#include <awali/sttc/alphabets/setalpha.hh>
#include <awali/sttc/labelset/letterset.hh>
#include <awali/sttc/labelset/oneset.hh>
#include <awali/sttc/ctx/context.hh>
#include <awali/sttc/weightset/b.hh>

namespace awali { namespace sttc {

  namespace ctx
  {
    using lal_char_b = context<letterset<sttc::set_alphabet<sttc::char_letters>>,
                               sttc::b>;
    using lao_br = context<oneset, sttc::ratexpset<lal_char_b>>;
  }
}}//end of ns awali::stc

#include <awali/sttc/ctx/instantiate.hh>

# ifndef MAYBE_EXTERN
#  define MAYBE_EXTERN extern
# endif

namespace awali { namespace sttc {

  AWALI_CTX_INSTANTIATE(ctx::lao_br);
}}//end of ns awali::stc

#endif // !AWALI_CTX_LAO_BR_HH
