// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef AWALI_NO_HISTORY_HH
# define AWALI_NO_HISTORY_HH

#include <awali/sttc/history/history.hh>

namespace awali { namespace sttc {

    class no_history : public history_base {
    public:

      std::ostream&
      print_state_name(state_t s, std::ostream& o,
                       const std::string& fmt) const {
	return o;
      }


      history_kind_t get_nature() const {
	return history_kind_t::NO_HISTORY;
      }

      bool has_history(state_t s) const {
	return false;
      }

      bool remove_history(state_t s) {
	return false;
      };


      bool has_history() {
	return false;
      }

      state_t get_state(state_t s) {
	throw std::runtime_error("Origin state not available");
      }

      std::vector<state_t> get_state_set(state_t s) {
	throw std::runtime_error("Origin state set not available");
      }
    };
  }
}//end of ns awali::stc

#endif // !AWALI_NO_HISTORY_HH
