// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

/**
 ** \file sttc/misc/indent.hh
 ** \brief Indentation relative functions.
 **/

#ifndef AWALI_MISC_INDENT_HH
# define AWALI_MISC_INDENT_HH

# include <iosfwd>
#include <awali/sttc/misc/export.hh>

namespace awali { namespace sttc { //LIBAWALI_API

  /// Increment the indentation.
  std::ostream& incindent(std::ostream& o);

  /// Decrement the indentation.
  std::ostream& decindent(std::ostream& o);

  /// Reset the indentation.
  std::ostream& resetindent(std::ostream& o);

  /// Set the indentation.
  std::ostream& indent(std::ostream& o);

  /// Print an end of line, then set the indentation.
  std::ostream& iendl(std::ostream& o);

  /// Increment the indentation, print an end of line, and set the indentation.
  std::ostream& incendl(std::ostream& o);

  /// Decrement the indentation, print an end of line, and set the indentation.
  std::ostream& decendl(std::ostream& o);


}}//end of ns awali::stc

#endif // !AWALI_MISC_INDENT_HH
