// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef AWALI_MISC_SIGNATURE_HH
# define AWALI_MISC_SIGNATURE_HH

# include <iosfwd>
# include <string>
# include <vector>

#include <awali/sttc/misc/attributes.hh>
#include <awali/sttc/misc/export.hh>

namespace awali { namespace sttc { //LIBAWALI_API

  struct signature
  {
    using sig_t = std::vector<std::string>;

    signature() = default;

    signature(const std::initializer_list<std::string>& l)
      : sig(l)
    {}

    std::string to_string() const;

    ATTRIBUTE_PURE
    bool operator<(const signature& that) const
    {
      return sig < that.sig;
    }

    sig_t::const_iterator begin() const
    {
      return std::begin(sig);
    }

    sig_t::const_iterator end() const
    {
      return std::end(sig);
    }

    sig_t sig;
  };

  /// Output a string, escaping special characters.
  std::ostream& operator<<(std::ostream& os, const signature& sig);
}}//end of ns awali::stc

#endif // !AWALI_MISC_SIGNATURE_HH
