// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef AWALI_WEIGHTSET_FWD_HH
# define AWALI_WEIGHTSET_FWD_HH

namespace awali { namespace sttc {

  namespace internal
  {
    // b.hh.
    class b_impl;

    // f2.hh.
    class f2_impl;

    //zz.hh
    template <unsigned int N>
    class zz_impl;

    // q.hh.
    class q_impl;

    // r.hh.
    class r_impl;

    // z.hh.
    class z_impl;

    // c.hh.
    class c_impl;

    // zmin.hh.
    class zmin_impl;

    // zmax.hh.
    class zmax_impl;

    // pmax.hh.
    class pmax_impl;
  }

  // polynomialset.hh.
  template <class Context>
  class polynomialset;

  // weightset.hh.
  template <typename WeightSet>
  struct variadic_mul_mixin;

  using b    = variadic_mul_mixin<internal::b_impl>;
  using f2   = variadic_mul_mixin<internal::f2_impl>;
  template <unsigned int N>
  using zz    = variadic_mul_mixin<internal::zz_impl<N>>;
  using q    = variadic_mul_mixin<internal::q_impl>;
  using c    = variadic_mul_mixin<internal::c_impl>;
  using r    = variadic_mul_mixin<internal::r_impl>;
  using z    = variadic_mul_mixin<internal::z_impl>;
  using zmin = variadic_mul_mixin<internal::zmin_impl>;
  using zmax = variadic_mul_mixin<internal::zmax_impl>;
  using pmax = variadic_mul_mixin<internal::pmax_impl>;

}}//end of ns awali::stc

#define AWALI_WEIGHTS_BINARY(Lhs, Rhs, Res)     \
  /** The join of two weightsets. */            \
  inline                                        \
  Res join(const Lhs&, const Rhs&)              \
  {                                             \
    return {};                                  \
  }

#define AWALI_WEIGHTS_BINARY_TEMPL(Tmplt, Lhs, Rhs, Res)      \
  /** The join of two templated weightsets. */               \
  template Tmplt                                             \
  inline                                                     \
  Res join(const Lhs&, const Rhs&)                           \
  {                                                          \
  return {};                                                 \
  }

#endif // !AWALI_WEIGHTSET_FWD_HH
