// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_SIMPLE_RATEXP_HH
#define DYN_SIMPLE_RATEXP_HH

#include<sstream>

namespace awali { namespace py {

  struct simple_ratexp_t {

  private:
    dyn::ratexp_t exp_;

  public:
    //Initialisation and conversion
    simple_ratexp_t() : exp_() {}

    simple_ratexp_t(const dyn::ratexp_t& a) : exp_((dyn::ratexp_t)a) {}

    void rewrap_into_me_(simple_ratexp_t other) {
        exp_= other;
    }

    operator dyn::ratexp_t() const {
      return dyn::ratexp_t(exp_);
    }

    simple_ratexp_t add(const simple_ratexp_t e) const {
      return simple_ratexp_t(exp_->add((dyn::ratexp_t)e));
    }

    simple_ratexp_t mult(const simple_ratexp_t e) const {
      return simple_ratexp_t(exp_->mult((dyn::ratexp_t)e));
    }

    simple_ratexp_t star() const {
      return simple_ratexp_t(exp_->star());
    }

    std::string print_() const {
      std::ostringstream os;
      exp_->print(os);
      return os.str();
    }

    std::string json() const{
      std::ostringstream os;
      exp_->json(os) << std::endl;
      return os.str();
    }

    std::string get_weightset(std::string format = "text") const {
        return exp_->get_context()->weightname(format);
    }

    std::string get_static_context() const {
        return exp_->get_context()->sname();
    }

    simple_ratexp_t copy() {
      return simple_ratexp_t(exp_);
    }

    bool is_valid() {
      return dyn::is_valid(exp_);
    }

    std::string constant_term() {
      return exp_->get_context()->weight_to_string(dyn::constant_term(exp_));
    }

  };
  simple_ratexp_t make_simple_ratexp1(std::string str) {
    return dyn::make_ratexp(str);
  }
  simple_ratexp_t make_simple_ratexp2(std::string str, std::string semiring) {
    return dyn::make_ratexp(str, semiring);
  }

  simple_ratexp_t make_simple_ratexp3(const std::string& exp, const std::string& sr, const std::string& alph) {
    return simple_ratexp_t(dyn::make_ratexp_with_alphabet(exp, alph, sr));
  }

  simple_ratexp_t make_simple_ratexp2bis(const std::string& exp, const std::string& alph) {
    return simple_ratexp_t(dyn::make_ratexp_with_alphabet(exp, alph));
  }









}}// end of namespace awali::py

#endif
