///
/// @file  SieveTables.hpp
/// @brief For performance reasons we cast the sieve byte array to an
///        uint64_t array in Sieve.cpp. This is not endian safe,
///        hence we need to do the same for the sieve lookup tables
///        i.e. the lookup tables are created as uint8_t arrays
///        and are then casted to uint64_t.
///
/// Copyright (C) 2018 Kim Walisch, <kim.walisch@gmail.com>
///
/// This file is distributed under the BSD License. See the COPYING
/// file in the top level directory.
///

#ifndef SIEVETABLES_HPP
#define SIEVETABLES_HPP

#include <stdint.h>

namespace {

#if 0
/// Algorithm for generating the unset_smaller[]
/// lookup table. This lookup table is used to unset
/// bits corresponding to numbers < start.

std::array<uint64_t, 240> unset_smaller;
std::array<int, 8> bit_values = { 1, 7, 11, 13, 17, 19, 23, 29 };

int shift = 0;

for (int i = 0; i < 240; i++)
{
    unset_smaller[i] = ~0ull << shift;

    for (int val : bit_values)
      if (i == (i - i % 30) + val)
        shift += 1;
}
#endif

#if 0
/// Algorithm for generating the unset_larger[]
/// lookup table. This lookup table is used to unset
/// bits corresponding to numbers > stop.

std::array<uint64_t, 240> unset_larger = { 0 };
std::array<int, 8> bit_values = { 1, 7, 11, 13, 17, 19, 23, 29 };

int shift = 64;

for (int i = 1; i < 240; i++)
{
    for (int val : bit_values)
      if (i == (i - i % 30) + val)
        shift -= 1;

    unset_larger[i] = ~0ull >> shift;
}
#endif

alignas(sizeof(uint64_t))
const uint8_t unset_smaller_bits[240 * 8] =
{
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80
};

/// Unset bits < start
const uint64_t* unset_smaller = (const uint64_t*) unset_smaller_bits;

alignas(sizeof(uint64_t))
const uint8_t unset_larger_bits[240 * 8] =
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

/// Unset bits > stop
const uint64_t* unset_larger = (const uint64_t*) unset_larger_bits;

} // namespace

#endif
