/* this contains all the code the the hash tables (transposition tables) */
#include "includes.h"
#include "knightcap.h"

int hash_hits, hash_misses;
static unsigned hash_tag;

extern struct state *state;

#if APLINUX
static unsigned num_cells;
static unsigned cell;
#endif

#define NLEVEL 2

#define PAR_HASH_LEVEL -1

static struct hash_entry *hash_table;
static unsigned hash_table_size;

#define DEPTH_LOW 0

static int initialised;

static void hash_reset_stats(void)
{
	hash_misses = hash_hits = 0;
}

void hash_reset(void)
{
	if (!initialised) return;

	if (!hash_table) {
		init_hash_table();
		return;
	}

	memset(hash_table, 0, 
	       sizeof(hash_table[0])*hash_table_size);
	lprintf(0,"reset hash table\n");
}


void init_hash_table(void)
{
	int size;

	hash_reset_stats();

	if (initialised) return;
	initialised = 1;

	do {
		hash_table_size = (state->hash_table_size * 1024*1024) / 
			sizeof(hash_table[0]);

		size = hash_table_size*sizeof(hash_table[0]);

		hash_table = (struct hash_entry *)malloc(size);

		if (!hash_table) {
			state->hash_table_size--;
		}
	} while (!hash_table);

	printf("hash table size %d MB\n", 
	       state->hash_table_size);

	hash_reset();
#if APLINUX
	num_cells = getncel();
	cell = getcid();
#endif
}

static inline unsigned get_index(Position *b)
{
	unsigned ret;
	ret = b->hash1 % hash_table_size;
#if NLEVEL
	ret &= ~(NLEVEL - 1);
#endif	
	return ret;
}

int check_hash(Position *b, 
	       int depth, Eval testv, Eval *v, Move *move)
{
	struct hash_entry *t;
	uint32 hashindex = get_index(b);

	t = &hash_table[hashindex];

#if APLINUX
	if (depth > PAR_HASH_LEVEL) {
		int get_flag = 0;
		int cid = (b->hash1 >> HASH_TABLE_BITS) % num_cells;
		get(cid, &b->h_entry, sizeof(*t), t, &get_flag, NULL);
		amcheck(&get_flag, 1);
	} else {
		b->h_entry = (*t);
	}
	t = &b->h_entry;
#endif
	
#if NLEVEL
	{
		int j;
		for (j=0;j<NLEVEL;j++, t++)
			if (t->hash2 == b->hash2 && 
			    t->hash1 == b->hash1) break;
		if (j == NLEVEL) {
			hash_misses++;
			return 0;
		}
	}
#else
	if (t->hash2 != b->hash2 || 
	    t->hash1 != b->hash1) {
		hash_misses++;
		return 0;
	}
#endif

	if (move) {
		/* even if we get a hash miss we return the move
		   if we have one - it might be a good guess */
		move->from = t->from;
		move->to = t->to;
	}

	if (t->depth < depth) {
		hash_misses++;
		return 0;
	}

	if (t->high < testv) {
		hash_hits++;
		(*v) = t->high;
		return 1;
	}

	if (t->low >= testv || t->low >= t->high) {
		hash_hits++;
		(*v) = t->low;
		return 1;
	}

	hash_misses++;
	return 0;
}



struct hash_entry *fetch_hash(Position *b)
{
	struct hash_entry *t;
	uint32 hashindex = get_index(b);

	t = &hash_table[hashindex];

#if NLEVEL
	{
		int j;
		for (j=0;j<NLEVEL;j++, t++)
			if (t->hash2 == b->hash2 && 
			    t->hash1 == b->hash1) break;
		if (j == NLEVEL) {
			return NULL;
		}
	}
#else
	if (t->hash2 != b->hash2 || 
	    t->hash1 != b->hash1) {
		hash_misses++;
		return 0;
	}
#endif

	return t;
}


int check_hash_quiesce(Position *b, Eval testv, Eval *v)
{
	struct hash_entry *t;
	uint32 hashindex = get_index(b);

	t = &hash_table[hashindex];

#if APLINUX
	if (depth > PAR_HASH_LEVEL) {
		int get_flag = 0;
		int cid = (b->hash1 >> HASH_TABLE_BITS) % num_cells;
		get(cid, &b->h_entry, sizeof(*t), t, &get_flag, NULL);
		amcheck(&get_flag, 1);
	} else {
		b->h_entry = (*t);
	}
	t = &b->h_entry;
#endif
	
#if NLEVEL
	{
		int j;
		for (j=0;j<NLEVEL;j++, t++)
			if (t->hash2 == b->hash2 && 
			    t->hash1 == b->hash1) break;
		if (j == NLEVEL) {
			hash_misses++;
			return 0;
		}
	}
#else
	if (t->hash2 != b->hash2 || 
	    t->hash1 != b->hash1) {
		hash_misses++;
		return 0;
	}
#endif

	if (t->high < testv) {
		hash_hits++;
		(*v) = t->high;
		return 1;
	}

	if (t->low >= testv || t->low >= t->high) {
		hash_hits++;
		(*v) = t->low;
		return 1;
	}

	hash_misses++;
	return 0;
}


void insert_hash(Position *b,
		 int depth, Eval testv, Eval evaluation, Move *move)
{
	struct hash_entry *t;
	uint32 hashindex = get_index(b);
	int diff;
#if APLINUX
	struct hash_entry *t1;
	int cid;
#endif

	t = &hash_table[hashindex];

#if APLINUX
	t1 = t;

	t = &b->h_entry;
#endif

	diff = hash_tag - t->tag;

	if (diff >= 0 && t->tag != 0 && diff < 4) {
#if NLEVEL
		int j, k;
		for (j=0;j<NLEVEL;j++, t++)
			if ((t->depth-diff) <= depth) break;
		if (j == NLEVEL) return;
		for (k=NLEVEL-(j+1); k>0; k--)
			t[k] = t[k-1];
#else
		if (t->depth > depth)
			return;
#endif
	}

	t->tag = hash_tag;
	
	if (depth < DEPTH_LOW)
		depth = DEPTH_LOW;

	if (t->hash2 == b->hash2 &&
	    t->hash1 == b->hash1 &&
	    depth == t->depth) {
		/* its a refinement */
		if (evaluation < testv) {
			t->high = evaluation;
		} else {
			t->low = evaluation;
		} 
	} else {
		if (evaluation < testv) {
			t->high = evaluation;
			t->low = -INFINITY;
		} else {
			t->low = evaluation;
			t->high = INFINITY;
		}
		
		t->depth = depth;
		t->hash2 = b->hash2;
		t->hash1 = b->hash1;
	}

	if (move) {
#if 0
		Position b1 = (*b);
		regen_moves(&b1);
		if (!legal_move(&b1, move)) {
			lprintf(0,"illegal move %s in hash table\n",
				short_movestr(&b1, move));
			print_board(&b1);
		}
#endif
		t->from = move->from;
		t->to = move->to;
	} else {
		t->from = t->to = A1;
	}

#if APLINUX
	if (depth > PAR_HASH_LEVEL) {
		cid = (b->hash1 >> HASH_TABLE_BITS) % num_cells;
		put(cid, t, sizeof(*t), t1, NULL, NULL, 0);
	} else {
		(*t1) = (*t);
	}
#endif
}


void insert_hash_quiesce(Position *b, Eval testv, Eval evaluation)
{
	struct hash_entry *t;
	uint32 hashindex = get_index(b);
	int diff;
#if APLINUX
	struct hash_entry *t1;
	int cid;
#endif

	t = &hash_table[hashindex];

#if APLINUX
	t1 = t;

	t = &b->h_entry;
#endif

	diff = hash_tag - t->tag;

	if (diff >= 0 && t->tag != 0 && diff < 4) {
#if NLEVEL
		int j, k;
		for (j=0;j<NLEVEL;j++, t++)
			if ((t->depth-diff) <= 0) break;
		if (j == NLEVEL) return;
		for (k=NLEVEL-(j+1); k>0; k--)
			t[k] = t[k-1];
#else
		if (t->depth > 0)
			return;
#endif
	}

	t->tag = hash_tag;

	if (evaluation < testv) {
		t->high = evaluation;
		t->low = evaluation;
	} else {
		t->low = evaluation;
		if (t->hash2 != b->hash2 ||
		    t->hash1 != b->hash1)
			t->high = INFINITY;
	}
	
	t->depth = 0;
	t->hash2 = b->hash2;
	t->hash1 = b->hash1;
	t->from = t->to = A1;

#if APLINUX
	if (depth > PAR_HASH_LEVEL) {
		cid = (b->hash1 >> HASH_TABLE_BITS) % num_cells;
		put(cid, t, sizeof(*t), t1, NULL, NULL, 0);
	} else {
		(*t1) = (*t);
	}
#endif
}



void hash_change_tag(unsigned tag)
{
	unsigned new_hash_tag = (tag % 255) + 1;
	if (new_hash_tag < hash_tag) {
		hash_reset();
	}
	hash_tag = new_hash_tag;
}

char *hashstats(void)
{
	static char ret[30];
	sprintf(ret, "hash=%d%%", 
		(100*hash_hits)/(hash_misses+hash_hits+1));
	return ret;
}



