#define DEFAULT_HASH_TABLE_SIZE 8 /* in Mb */

#define USE_HASH_TABLES 1
#define USE_CAPTURE_DEEPENING 1
#define USE_PAWN_DEEPENING 1
#define USE_CHECK_DEEPENING 1
#define USE_NULL_MOVE 1
#define USE_RAZORING 1
#define USE_SEMI_QUIESCE 0

#define RESIGN_VALUE (ROOK_VALUE + PAWN_VALUE)

#define RANDOM_EVAL_RANGE 2
#define BONUS_RANGE 4

#define FUTILE_THRESHOLD 200

#define EARLY_QUIESCE_LEVEL 0

#define NULL_MOVE_PLY 3
#define PONDER_NULL_MOVE_PLY 3

#define DOUBLE_EXTENSION_PLY 12

#define RAZOR_THRESHOLD (1.5*PAWN_VALUE)

#define NULL_MOVE_THRESHOLD 25

#define MTD_THRESHOLD 2

#define MAX_CELLS 64

#define CAPTURE_SEARCH_DEPTH 0

#define HASH_OFFSET 64

#define USE_FORWARD_PRUNING 0
#define PRUNE_THRESHOLD (PAWN_VALUE/4)

#define PAR_SPLIT_LEVEL 1

#define TREE_PRINT_PLY 0

#define MAX_DEPTH 25

#define WALL_CLOCK 1

#define NUM_SQUARES (8*8)
#define MAX_MOVES (306) /* the maximum number of moves that can be
			   made in one move - probably a gross
			   overestimate */
#define MAX_GAME_MOVES 1000 /* the players should give up by then :-) */
#define PIECE_NONE 0
#define PIECE_WHITE 1
#define PIECE_BLACK -1

#define IKING 0
#define IQUEEN 1
#define IKROOK 2
#define IQROOK 3
#define IKBISHOP 4
#define IQBISHOP 5
#define IKKNIGHT 6
#define IQKNIGHT 7

#define IQRPAWN 8
#define IQNPAWN 9
#define IQBPAWN 10
#define IQPAWN 11
#define IKPAWN 12
#define IKBPAWN 13
#define IKNPAWN 14
#define IKRPAWN 15

#define WHITE_MASK (0x0000FFFF)
#define BLACK_MASK (0xFFFF0000)
#define WKING_MASK (0x00000001)
#define BKING_MASK (0x00010000)
#define KING_MASK  (0x00010001)
#define WQUEEN_MASK (0x00000002)
#define BQUEEN_MASK (0x00020000)
#define QUEEN_MASK  (0x00020002)
#define WROOK_MASK (0x0000000C)
#define WKROOK_MASK (0x00000004)
#define WQROOK_MASK (0x00000008)
#define WBISHOP_MASK (0x00000030)
#define WKBISHOP_MASK (0x00000010)
#define WQBISHOP_MASK (0x00000020)
#define BBISHOP_MASK (0x00300000)
#define BKBISHOP_MASK (0x00100000)
#define BQBISHOP_MASK (0x00200000)
#define BISHOP_MASK   (0x00300030)
#define WKNIGHT_MASK (0x000000C0)
#define BKNIGHT_MASK (0x00C00000)
#define BROOK_MASK (0x000C0000)
#define BKROOK_MASK (0x00040000)
#define BQROOK_MASK (0x00080000)
#define WPAWN_MASK (0x0000FF00)
#define BPAWN_MASK (0xFF000000)
#define WPIECE_MASK (0x000000FF)
#define BPIECE_MASK (0x00FF0000)

#define INFINITY (4050)
#define ILLEGAL (-4000)
#define WIN (-(ILLEGAL+1))
#define MAX_MATERIAL (3000)

#define STALEMATE 2

#define DEFAULT_MOVE_TIME 10

#define POSN(x,y) ((y) + (x)*8)
#define XPOS(p) ((p)>>3)
#define YPOS(p) ((p)&7)

#undef NORTH
#undef SOUTH
#undef EAST
#undef WEST

#define NORTH (1)
#define SOUTH (-1)
#define EAST  (8)
#define WEST  (-8)
#define NORTH_EAST (NORTH+EAST)
#define NORTH_WEST (NORTH+WEST)
#define SOUTH_EAST (SOUTH+EAST)
#define SOUTH_WEST (SOUTH+WEST)

#define WHITE_CASTLE_SHORT (1<<0)
#define WHITE_CASTLE_LONG (1<<1)
#define BLACK_CASTLE_SHORT (1<<2)
#define BLACK_CASTLE_LONG (1<<3)
#define WHITE_CASTLED (1<<4)
#define BLACK_CASTLED (1<<5)
#define FLAG_CHECK (1<<7)
#define FLAG_PREV_CHECK (1<<8)
#define FLAG_WHITE_PROMOTE (1<<11)
#define FLAG_BLACK_PROMOTE (1<<12)
#define FLAG_ACCEPT_DRAW (1<<13)

#define FLAG_WHITE_CAN_CASTLE (WHITE_CASTLE_SHORT | WHITE_CASTLE_LONG)
#define FLAG_BLACK_CAN_CASTLE (BLACK_CASTLE_SHORT | BLACK_CASTLE_LONG)
#define FLAG_CAN_CASTLE (FLAG_WHITE_CAN_CASTLE | FLAG_BLACK_CAN_CASTLE)

#define REPITITION_LENGTH 101

/* lots of things are relative to the material value of a pawn */
#define PAWN_VALUE 100
#define KNIGHT_VALUE 401
#define BISHOP_VALUE 412
#define ROOK_VALUE 603
#define QUEEN_VALUE 1200
#define KING_VALUE 0 /* a king value is never needed */

#define INITIAL_MATERIAL (QUEEN_VALUE + 2*ROOK_VALUE + 2*BISHOP_VALUE + 2*KNIGHT_VALUE + 8*PAWN_VALUE)


typedef short int16;
typedef unsigned uint32;
typedef unsigned long long uint64;


typedef enum {B_KING = -6,B_QUEEN = -5,B_ROOK = -4,B_BISHOP = -3,
	      B_KNIGHT = -2,B_PAWN = -1,
	      NONE=0, 
	      PAWN=1, KNIGHT=2, BISHOP=3, ROOK=4, QUEEN=5, KING=6} PieceT;

typedef enum {A1=0, A2, A3, A4, A5, A6, A7, A8,
	      B1, B2, B3, B4, B5, B6, B7, B8,
	      C1, C2, C3, C4, C5, C6, C7, C8,
	      D1, D2, D3, D4, D5, D6, D7, D8,
	      E1, E2, E3, E4, E5, E6, E7, E8,
	      F1, F2, F3, F4, F5, F6, F7, F8,
	      G1, G2, G3, G4, G5, G6, G7, G8,
	      H1, H2, H3, H4, H5, H6, H7, H8} SquareT;

/* this is the basic material value of pieces, indexed by the abolute
   value of the piece */
static const int mat_value[KING+1] = {0,
				      PAWN_VALUE, KNIGHT_VALUE,
				      BISHOP_VALUE, ROOK_VALUE, 
				      QUEEN_VALUE, KING_VALUE};


#define DEBUG_FRIENDLY 1
#if DEBUG_FRIENDLY
typedef SquareT Square;
typedef PieceT Piece;
#else
typedef char Square;
typedef char Piece;
#endif

typedef enum {OPENING=0, MIDDLE, ENDING} GameStage;

/* use a short to hold evaluations */
typedef int16 Eval;

typedef struct {
	Square from, to;
	int v, bonus;
} Move;

typedef struct {
	Piece p;
	Square pos;
} PieceStruct;


typedef uint64 BitBoard;

struct hash_entry {
	uint32 hash1;
	uint32 hash2;
	int16 low;
	int16 high;
	unsigned char depth;
	unsigned char tag;
	unsigned char from;
	unsigned char to;
};

typedef struct Position {
	/* this section needs to be copied in do_move */
	uint32 hash1, hash2;
	uint32 sliding_mask; /* mask of pieces that can "slide"
				  (bishops, rooks, queens) */
	uint32 pawns7th;     /* mask of pawns on the 7th rank */
	uint32 piece_mask;   /* mask of which pieces are not pawns */
	uint32 material_mask; /* mask of all pieces on the board */
	Piece board[NUM_SQUARES]; /* the board itself */
	char pboard[NUM_SQUARES]; /* pointers into the piece list */
	PieceStruct pieces[32];   /* the piece list - this is never
				     reordered as otherwise the masks
				     would become invalid */
	Eval control[NUM_SQUARES]; /* the board control value for each 
				      square */
	unsigned char mobility[32]; /* mobility value for each piece */
	int white_moves;            /* whites total mobility */
	int black_moves;            /* blacks total mobility */
	Eval piece_values[32];      /* the value of each piece at the last
				       eval call */
	BitBoard control_change; /* which squares may have had a change
				    in who controls them - this speeeds
				    up the board control function a lot */
	int stage;             /* stage of the game */
	uint32 piece_change; /* a bitmap of which pieces need to be
				  recalculated */
	uint32 trapped_mask; /* a bitmap of pieces which are trapped,
				which means they have no friendly squares
				to flee to */
	uint32 hung_mask;    /* a bitmap of pieces which are hung. This means
				  they are on a square that the opponent
				  controls */
	uint32 attacking_mask; /* a bitmap of pieces which are attacking
				    some enemy piece, and are thus being
				    useful */
	int positional_value; /* the positional eval last time the eval fn
				 was called */
	int w_material;       /* whites material value */
	int b_material;       /* blacks material value */
	Eval board_control;   /* the total board control value */
	Eval piece_value;     /* the total piece values (not material) */
	Eval evaluation;      /* evaluation after a search */

	/* and this section doesn't get copied by do_move */
	unsigned dont_copy; /* dummy variable */
	uint32 topieces[NUM_SQUARES]; /* a bitmap for each square
					   which says what pieces are
					   supporting/attacking the
					   square. This is the core of
					   the move generator and the
					   board control function */
	Move *moves;
	int num_moves;
	int last_dest;
	int prev_capture;
	int capture;
	uint32 flags;
	int enpassent;
	int promotion;
	int fifty_count;
	int move_num;
	unsigned winner;
	struct hash_entry h_entry;
	struct Position *oldb;
} Position;

struct state {
	Position position;
	int computer;
	int moved;
	float curquat[4];
	float scale;
	int quit;
	int stop_search;
	int move_time;
	int bonus_time[3];
	int time_limit;
	int always_think;
	int flip_view;
	int ics_robot;
	int hash_table_size;
	Move game_record[MAX_GAME_MOVES];
	uint32 hash_list[MAX_GAME_MOVES]; /* for repitition */
};

#define WHITEPIECES(b) ((b)->pieces)
#define BLACKPIECES(b) ((b)->pieces + 16)
#define PIECES(b,player) ((player)>0?WHITEPIECES(b):BLACKPIECES(b))


#include "proto.h"

#ifdef i386
static inline int ff_one(uint32 word)
{
	__asm__("bsfl %1,%0"
		:"=r" (word)
		:"r" (word));
	return word;
}
#else
static inline int ff_one(uint32 mask)
{
	static const int first[16] = {-1, 0, 1, 0, 2, 0, 1, 0, 3, 
				      0, 1, 0, 2, 0, 1, 0};
	int ret=0;
	if (!(mask & 0xFFFF)) {
		mask >>= 16;
		ret += 16;
	}

	if (!(mask & 0xFF)) {
		mask >>= 8;
		ret += 8;
	}

	if (!(mask & 0xF)) {
		mask >>= 4;
		ret += 4;
	}

	return ret + first[mask & 0xF];
}
#endif

static inline int fl_one(uint32 mask)
{
	static const int last[16] = {-1, 0, 1, 1, 2, 2, 2, 2, 3, 
				     3, 3, 3, 3, 3, 3, 3};
	int ret=0;
	if (mask & 0xFFFF0000) {
		mask >>= 16;
		ret += 16;
	}

	if (mask & 0xFF00) {
		mask >>= 8;
		ret += 8;
	}

	if (mask & 0xF0) {
		mask >>= 4;
		ret += 4;
	}

	return ret + last[mask & 0xF];
}

static inline int ff_bb(BitBoard bb)
{
	if (bb & 0xFFFFFFFF) return ff_one(bb & 0xFFFFFFFF);
	return ff_one(bb >> 32) + 32;
}

/* determine if two pieces or players are the same color */
static inline int same_color(Piece p1, Piece p2)
{
	return ((p1 ^ p2) >= 0);
}

static inline int is_white(Piece p1)
{
	return p1 > 0;
}

static inline int is_black(Piece p1)
{
	return p1 < 0;
}

static inline Square mirror_square(Square sq)
{
	return sq ^ 7;
}

#define ABS(x) ((x)<0?-(x):(x))

static inline int imin(int i1, int i2)
{
	return i1 > i2? i2 : i1;
}

static inline int imax(int i1, int i2)
{
	return i1 > i2? i1 : i2;
}

static inline PieceStruct *get_pboard(Position *b, Square pos)
{
	if (b->pboard[pos] == -1) return NULL;
	return b->pieces + b->pboard[pos];
}

static inline void set_pboard(Position *b, Square pos, PieceStruct *piece)
{
	if (piece == NULL) 
		b->pboard[pos] = -1;
	else
		b->pboard[pos] = piece - b->pieces;
}


static inline int is_zero_move(Move *move)
{
	return (move->from == A1 && move->to == A1);
}

static inline int same_move(Move *m1, Move *m2)
{
	return (m1->from == m2->from && m1->to == m2->to);
}

static inline void zero_move(Move *move)
{
	move->from = move->to = A1;
}

static inline int bad_square(Square sq)
{
	return ((sq & ~63) != 0);
}

static inline int white_square(Square sq)
{
	return ((sq ^ (sq>>3)) & 1);
}

static inline int black_square(Square sq)
{
	return !white_square(sq);
}

static inline int blacks_move(Position *b)
{
	return (b->move_num & 1);
}

static inline int whites_move(Position *b)
{
	return (!blacks_move(b));
}

static inline int next_to_play(Position *b)
{
	if (whites_move(b)) return 1;
	return -1;
}

static inline uint32 player_mask(Position *b)
{
	if (whites_move(b)) return WHITE_MASK;
	return BLACK_MASK;
}

#define OneBB (~(BitBoard)0)
#define ZeroBB ((BitBoard)0)
#define BitBB(sq) (((BitBoard)1) << (sq))
#define QueryBB(bb, sq) (((bb) & BitBB(sq)) != ZeroBB)
#define SetBB(bb, sq) ((bb) |= BitBB(sq))
#define ClearBB(bb, sq) ((bb) &= ~BitBB(sq))

extern char capture_map[2*KING+1][NUM_SQUARES][NUM_SQUARES];


