#include "includes.h"
#include "knightcap.h"

static FILE *logfile;

void log_close(void)
{
	fclose(logfile);
	logfile = NULL;
}

int lprintf(int level, char *format_str, ...)
{
	va_list ap;  


	if (!logfile) {
#if APLINUX
		logfile = fopen("/ddv/data/tridge/knightcap.log","w");
#else
		logfile = fopen("knightcap.log","w");
#endif
	}
  
	va_start(ap, format_str);

	if (level == 0) {
		vfprintf(stdout,format_str,ap);
		fflush(stdout);
	}

	if (logfile) {
		vfprintf(logfile,format_str,ap);
		if (level == 0)
			fflush(logfile);
	}

	va_end(ap);


	return(0);
}

void lindent(int level, int ply)
{
	while (ply--) 
		lprintf(level, "\t");
}
