/* move ordering code */
#include "includes.h"
#include "knightcap.h"

#define NUM_CUTOFFS 1

static unsigned history[NUM_SQUARES][NUM_SQUARES];
static Move killer[MAX_DEPTH];

void order_clear(int move_num)
{
	static int last_num;
	int x,y, delta;

	if (last_num == move_num)
		return;

	delta = imax(move_num - last_num, 0);
	last_num = move_num;

	if (delta <= 0) return;

	for (x=A1;x<=H8;x++)
		for (y=A1;y<=H8;y++)
			history[x][y] >>= delta;
}


void cutoff_hint(Position *b, Move *move, int depth, int ply)
{
	if (ply < MAX_DEPTH)
		killer[ply] = (*move);

	if (depth > 0)
		history[move->from][move->to] += (1 << depth);
}

static Move hash_move;

static int order_fn(Position *b, Move *m, int ply)
{
	int ret = 0;

	if (same_move(m, &hash_move)) {
		ret += 1000000;
	}

	if (ply < MAX_DEPTH && same_move(m, &killer[ply])) {
		ret += 50000;
	}

	if (b->last_dest == m->to) {
		ret += 100000 - abs(b->board[m->from]);
	}

	if (b->board[m->to])
		ret += 1000;

	if (whites_move(b)) {
		if (b->control[m->from] < 0) ret += b->board[m->from] * 64;
		if (b->control[m->to] >= 0) {
			ret += 8;
			if (b->board[m->to]) 
				ret += 60000 + mat_value[-b->board[m->to]] -
					mat_value[b->board[m->from]];
		}
	} else {
		if (b->control[m->from] > 0) ret -= b->board[m->from] * 64;
		if (b->control[m->to] <= 0) {
			ret += 8;
			if (b->board[m->to]) 
				ret += 60000 + mat_value[b->board[m->to]] -
					mat_value[-b->board[m->from]];
		}
	}

	return ret + (history[m->from][m->to] << 3);
}

void order_moves(Position *b, Move *moves, int n, int ply, Move *m1)
{
	int m;

	if (m1)
		hash_move = (*m1);

	for (m=0;m<n;m++)
		moves[m].v = order_fn(b, &moves[m], ply);

	sort_moves(moves, n);
}

