/* -*- c-file-style: "java"; indent-tabs-mode: nil -*-
 * 
 * distcc -- A simple distributed compiler system
 * $Header: /data/cvs/distcc/src/daemon.c,v 1.43 2002/05/17 03:45:42 mbp Exp $ 
 *
 * Copyright (C) 2002 by Martin Pool <mbp@samba.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


                /* "Just like distributed.net, only useful!" */

/**
 * @file
 *
 * distcc volunteer server.  Accepts and serves requests to compile
 * files.
 *
 * May be run from inetd (default if stdin is a socket), or as a
 * daemon by itslef.  The second course uses preforking and limits the
 * number of children running at any time, which is perhaps slightly
 * more efficient.
 *
 * Nothing should be written to stderr, but anything that escapes goes
 * to <tt>/tmp/distccd.log</tt>.
 *
 * @todo Pre-fork a certain number of servers, and then have them all
 * accept on the same socket.  This might make startup slightly
 * faster, and also allows easy regulation of load.  Children should
 * not exit when done, but rather accept a new connection.
 *
 * @todo Later, make the parent log any children that exit or die, and
 * restart them.  If the parent is killed, it should just close the
 * listening socket, which ought to cause the children to die off.
 *
 * @todo Option to set niceness.
 **/


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <assert.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <syslog.h>

#include <sys/stat.h>
#include <sys/sendfile.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/socket.h>

#include "distcc.h"
#include "trace.h"
#include "io.h"
#include "util.h"
#include "rpc.h"



static int dcc_be_server(void)
{
    int listen_fd;
    int port = 4200;
    
    if ((listen_fd = open_socket_in(port)) == -1)
        return -1;

    rs_log(RS_LOG_INFO|RS_LOG_NONAME, "listening on port %d",
           port);

    while (1) {
        int acc_fd;

        acc_fd = accept(listen_fd, NULL, 0);
        if (acc_fd == -1) {
            rs_log_error("accept failed: %s", strerror(errno));
            continue;
        }

        /* Don't fork yet */
        dcc_accept_job(acc_fd);
        close(acc_fd);
        dcc_cleanup_tempfiles();
    }

    /* Should not normally return */
    return 0;
}


/**
 * @file
 * distcc daemon.  Must be run from inetd.
 **/
int main(int argc, char *argv[])
{
    openlog("distccd", LOG_PID, LOG_DAEMON);

    if (is_a_socket(STDIN_FILENO)) {
        if (redirect_fd(STDERR_FILENO, "/tmp/distccd.log",
                        O_CREAT|O_WRONLY|O_APPEND) == -1)
            return 1;
        rs_trace_to(rs_trace_syslog);
    } else {
        /* let command-line errors go to stderr */
        rs_trace_to(rs_trace_stderr);
    }

    rs_trace_set_level(RS_LOG_INFO);

    if (distccd_parse_options(argc, (const char **) argv))
        return EXIT_FAILURE;

    /* now even daemons started from command line should use syslog. */
    rs_trace_to(rs_trace_syslog);
    if (is_a_socket(STDIN_FILENO)) {
        int ret;
        ret = dcc_accept_job(STDIN_FILENO);
        dcc_cleanup_tempfiles();
        return ret == 0 ? EXIT_SUCCESS : EXIT_FAILURE;
    } else {
        return dcc_be_server() == 0 ? EXIT_SUCCESS : EXIT_FAILURE;
    }
}
