/* -*- c-file-style: "java"; indent-tabs-mode: nil -*-
 * 
 * distcc -- A simple distributed compiler system
 * $Id: distcc.h,v 1.42 2002/05/17 04:09:01 mbp Exp $ 
 *
 * Copyright (C) 2002 by Martin Pool <mbp@samba.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#define PROTO_VER 1

int str_endswith(const char *tail, const char *tiger);
int argv_contains(char **argv, const char *s);

/* exec.c */
void dcc_run_here(char **argv, const char *, const char *)
     __attribute__((noreturn));
int dcc_spawn_child(char **argv, pid_t *pidptr, const char *, const char *);
int dcc_wait_child(pid_t pid, int *wait_status);
int dcc_critique_status(int s, const char *, const char *);
void dcc_note_execution(const char *hostname, char **argv);


/* arg.c */
int dcc_deepcopy_argv(char **, /*@relnull@*/ char ***);
int dcc_shallowcopy_argv(char **, /*@relnull@*/ char ***, int);
int dcc_set_action_opt(char **, char *);
int dcc_set_output(char **, char *);
int dcc_set_input(char **, char *);
int dcc_scan_args(char *argv[], /*@out@*/ /*@relnull@*/ char **orig_o,
                  /*@out@ @relnull@*/ char **orig_i);
char *dcc_argv_tostr(char **a);

int dcc_argv_len(char **a);

/* clinet.c */
int dcc_cli_connect(const char *host);

/* dopt.c */
int distccd_parse_options(int argc, const char *argv[]);

/* where.c */
int dcc_pick_buildhost(char **buildhost);

/* tempfile.c */
const char *dcc_get_tempdir(void);
int dcc_setup_tempdir(void);
void dcc_cleanup_tempfiles(void);
char *dcc_make_tmpnam(const char *, const char *suffix);

/* serve.c */
int dcc_accept_job(int fd);

/* srvnet.c */
void dcc_log_clientname(int fd);

/* help.c */
int dcc_show_copyright(void);
int dcc_show_version(const char *prog);
