/* -*- c-file-style: "java"; indent-tabs-mode: nil -*-
 * 
 * distcc -- A simple distributed compiler system
 * $Header: /data/cvs/distcc/src/dopt.c,v 1.4 2002/05/17 04:09:01 mbp Exp $ 
 *
 * Copyright (C) 2002 by Martin Pool <mbp@samba.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


/**
 * @file
 *
 * Parse and apply server options.
 **/


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <assert.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <popt.h>

#include "distcc.h"
#include "trace.h"
#include "io.h"

int arg_nice_inc;

const struct poptOption options[] = {
    { "nice", 'N', POPT_ARG_INT, &arg_nice_inc, 'N', 0, 0 },
    { "help", 0, POPT_ARG_NONE, 0, '?', 0, 0 },
    { "version", 0, POPT_ARG_NONE, 0, 'V', 0, 0 },
    { 0, 0, 0, 0, 0, 0, 0 }
};


static void distccd_show_usage(void)
{
    dcc_show_version("distccd");
    dcc_show_copyright();
    printf (
"Usage:\n"
"   distccd [OPTIONS]\n"
"\n"
"Options:\n"
"   --help                     explain usage and exit\n"
"   --version                  show version and exit\n"
"   -N, --nice LEVEL           lower priority, 20=most nice\n"
"\n"
"distccd runs either from inetd or as a standalone daemon to compile\n"
"files submitted by the distcc client.  distccd runs on TCP port 4200.\n"
"\n"
"distccd should only run on trusted networks.\n"
);
}


int distccd_parse_options(int argc, const char **argv)
{
    poptContext po;
    int rc;

    po = poptGetContext("distccd", argc, argv, options, 0);

    while ((rc = poptGetNextOpt(po)) != -1) {
        switch (rc) {
        case '?':
            distccd_show_usage();
            exit(0);
            
        case 'N':
            /* just do it now */
            if (nice(arg_nice_inc) == -1) {
                rs_log_warning("nice %d failed: %s", arg_nice_inc,
                               strerror(errno));
                /* continue anyhow */
            }
            break;

        case 'V':
            dcc_show_version("distccd");
            exit(EXIT_SUCCESS);
            
        default:                /* bad? */
            rs_log(RS_LOG_NONAME|RS_LOG_ERR|RS_LOG_NO_PID, "%s: %s",
                   poptBadOption(po, POPT_BADOPTION_NOALIAS),
                   poptStrerror(rc));
            return -1;
        }
    }

    poptFreeContext(po);
    return 0;
}
