/* -*- c-file-style: "java"; indent-tabs-mode: nil -*-
 * 
 * distcc -- A simple distributed compiler system
 * $Header: /data/cvs/distcc/src/rpc.c,v 1.16 2002/05/15 05:01:16 mbp Exp $ 
 *
 * Copyright (C) 2002 by Martin Pool <mbp@samba.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


			/* 15 Every one that is found shall be thrust
			 * through; and every one that is joined unto
			 * them shall fall by the sword.
			 *		-- Isaiah 13 */



#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <assert.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>

#include <sys/stat.h>
#include <sys/sendfile.h>

#include "distcc.h"
#include "trace.h"
#include "io.h"
#include "rpc.h"


/**
 * Send start of a result: DONE <version>
 **/
int dcc_x_result_header(int ofd)
{
    return dcc_write_token(ofd, "DONE")
        || dcc_write_int(ofd, PROTO_VER);
}


int dcc_r_result_header(int ifd)
{
    unsigned vers;
    
    if (dcc_expect_token(ifd, "DONE")
        || dcc_read_int(ifd, &vers))
        return -1;

    if (vers != PROTO_VER) {
        rs_log_error("got version %d not %d in response from server",
                     vers, PROTO_VER);
        return -1;
    }

    rs_trace("got response header");

    return 0;
}


int dcc_x_cc_status(int ofd, int status)
{
    return dcc_write_token(ofd, "STAT")
        || dcc_write_int(ofd, (unsigned) status);
}


int dcc_r_cc_status(int ifd, int *status)
{
    return dcc_expect_token(ifd, "STAT")
        || dcc_read_int(ifd, (unsigned *) status);
}


int dcc_r_token(int ifd, char *buf)
{
    return dcc_readx(ifd, buf, 4);
}

