/* -*- c-file-style: "java"; indent-tabs-mode: nil -*-
 * 
 * distcc -- A simple distributed compiler system
 * $Header: /data/cvs/distcc/src/srvnet.c,v 1.4 2002/04/30 08:05:23 mbp Exp $ 
 *
 * Copyright (C) 2002 by Martin Pool <mbp@samba.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


/**
 * @file
 *
 * Server-side networking.
 **/


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <assert.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <netdb.h>


#include <sys/stat.h>
#include <sys/sendfile.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/param.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <netinet/tcp.h>

#include "distcc.h"
#include "trace.h"
#include "io.h"
#include "util.h"
#include "rpc.h"

int open_socket_in(int port)
{
    struct sockaddr_in sock;
    int res;
    int one = 1;

    memset((char *) &sock, 0, sizeof(sock));
    sock.sin_port = htons(port);
    sock.sin_family = PF_INET;
    sock.sin_addr.s_addr = INADDR_ANY;

    res = socket(PF_INET, SOCK_STREAM, 0);
    if (res == -1) {
	rs_log_error("socket creation failed: %s", strerror(errno));
	return -1;
    }

    setsockopt(res, SOL_SOCKET, SO_REUSEADDR, (char *) &one, sizeof(one));

    /* now we've got a socket - we need to bind it */
    if (bind(res, (struct sockaddr *) &sock, sizeof(sock)) == -1) {
	rs_log_error("bind failed on port %d: %s", port, strerror(errno));
	close(res);
	return -1;
    }

    if (listen(res, 10)) {
        rs_log_error("listen failed: %s", strerror(errno));
        return -1;
    }

    return res;
}


/**
 * Determine if a file descriptor is in fact a socket
 **/
int is_a_socket(int fd)
{
    int v, l;
    l = sizeof(int);
    return (getsockopt(fd, SOL_SOCKET, SO_TYPE, (char *) &v, &l) == 0);
}



void dcc_log_clientname(int fd)
{
    struct sockaddr_in sain;
    socklen_t len = sizeof sain;
    struct hostent *he;

    if ((getpeername(fd, (struct sockaddr *) &sain, &len) == -1)
        || (len > sizeof sain)) {
        rs_log_warning("failed to get peer name: %s",
                       strerror(errno));
        return;
    }

    he = gethostbyaddr((const char *) &sain.sin_addr,
                       sizeof(sain.sin_addr),
                       sain.sin_family);
    if (!he) {
        rs_log_warning("failed to lookup peer name: %s",
                       hstrerror(h_errno));
        return;
    }

    rs_log(RS_LOG_INFO|RS_LOG_NONAME,
           "connection from %s", he->h_name);
}
