/* -*- c-file-style: "java"; indent-tabs-mode: nil -*-
 * 
 * distcc -- A simple distributed compiler system
 * $Header: /data/cvs/distcc/src/clinet.c,v 1.17 2002/06/02 03:59:45 mbp Exp $ 
 *
 * Copyright (C) 2002 by Martin Pool <mbp@samba.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


                        /* "Speed, it seems to me, provides the one
                           genuinely modern pleasure."
                                -- Aldous Huxley (1894 - 1963) */


#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <assert.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>

#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <netinet/tcp.h>

#include <netdb.h>

#include "distcc.h"
#include "trace.h"
#include "io.h"

#ifndef HAVE_IN_PORT_T
typedef int in_port_t;
#endif


/**
 * @file
 *
 * Client-side networking.
 *
 * @todo In error messages, show the name of the relevant host.
 * Should do this even in readx(), etc.
 **/



/**
 * Open a socket to a tcp remote host with the specified port.
 *
 * Based on code from rsync.
 **/
int dcc_open_socket_out(const char *host, int port)
{
    int type = SOCK_STREAM;
    struct sockaddr_in sock_out;
    int res;
    struct hostent *hp;

    /* Ignore SIGPIPE; we consistently check error codes and will
     * see the EPIPE. */
    signal(SIGPIPE, SIG_IGN);

    res = socket(PF_INET, type, 0);
    if (res == -1) {
	rs_log_error("failed to create socket: %s", strerror(errno));
	return -1;
    }

    hp = gethostbyname(host);
    if (!hp) {
	rs_log_error("unknown host: \"%s\"", host);
	(void) close(res);
	return -1;
    }

    memcpy(&sock_out.sin_addr, hp->h_addr, (size_t) hp->h_length);
    sock_out.sin_port = htons((in_port_t) port);
    sock_out.sin_family = (sa_family_t) PF_INET;

    if (connect(res, (struct sockaddr *) &sock_out, (int) sizeof(sock_out))) {
        rs_log_error("failed to connect to %s port %d: %s", host, port, 
                     strerror(errno));
	(void) close(res);
	return -1;
    }

    rs_trace("client got connection to %s port %d on fd%d", host, port, res);

    return res;
}



/**
 * Open a connection to a compile server.
 *
 * Eventually this routine needs to choose one that is likely to be
 * free.  For the moment we just dump to a file.
 *
 * @retval >=0 file descriptor
 * @retval -1 error
 **/
int dcc_cli_connect(const char *build_host)
{
    /* TODO: Don't try for too long to connect.  If we fail, run
     * locally or on some other machine. */
    return dcc_open_socket_out(build_host, 4200);
}


