/* -*- c-file-style: "java"; indent-tabs-mode: nil -*-
 * 
 * distcc -- A simple distributed compiler system
 * $Header: /data/cvs/distcc/src/daemon.c,v 1.58 2002/06/08 15:44:14 mbp Exp $ 
 *
 * Copyright (C) 2002 by Martin Pool <mbp@samba.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


                /* "Just like distributed.net, only useful!" */

/**
 * @file
 *
 * distcc volunteer server.  Accepts and serves requests to compile
 * files.
 *
 * May be run from inetd (default if stdin is a socket), or as a
 * daemon by itslef.  The second course uses preforking and limits the
 * number of children running at any time, which is perhaps slightly
 * more efficient.
 *
 * distcc has an adequate but perhaps not optimal system for deciding
 * where to send files.  The general principle is that the server
 * should say how many jobs it is willing to accept, rather than the
 * client having to know.  This is probably good in two ways: it
 * allows for people in the future to impose limits on how much work
 * their contributed machine will do, and secondly it seems better to
 * put this information in one place rather than on every client.
 **/

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <assert.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <syslog.h>
#include <signal.h>

#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/socket.h>

#include "exitcode.h"
#include "distcc.h"
#include "trace.h"
#include "io.h"
#include "util.h"
#include "opt.h"
#include "rpc.h"


/* for trace.c */
char const *rs_program_name = "distccd";




/**
 * distcc daemon.  May run from inetd, or standalone.  Accepts
 * requests from clients to compile files.
 **/
int main(int argc, char *argv[])
{
    openlog("distccd", LOG_PID, LOG_DAEMON);
    rs_trace_to(rs_trace_syslog);
    rs_trace_set_level(RS_LOG_INFO);
    atexit(dcc_cleanup_tempfiles);

    if (distccd_parse_options(argc, (const char **) argv))
        dcc_exit(EXIT_DISTCC_FAILED);

    /* This test might need to be a bit more complex when we want to
     * support ssh and stuff like that.  Perhaps it would be better to
     * always serve stdin, and then complain if it's a terminal? */

    if (is_a_socket(STDIN_FILENO)) {
        rs_log_info("stdin is socket; assuming inetd mode");
        dcc_inetd_server();
    } else {
        dcc_standalone_server();
    }
}


/**
 * Serve a single file on stdin, and then exit.
 **/
void dcc_inetd_server(void)
{
    dcc_exit(dcc_accept_job(STDIN_FILENO) ? EXIT_DISTCC_FAILED : EXIT_SUCCESS);
}


