/* -*- c-file-style: "java"; indent-tabs-mode: nil -*-
 * 
 * distcc -- A simple distributed compiler system
 * $Id: distcc.h,v 1.54 2002/06/21 09:48:06 mbp Exp $ 
 *
 * Copyright (C) 2002 by Martin Pool <mbp@samba.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#define PROTO_VER 1

#ifdef NORETURN
/* nothing */
#elif defined(__GNUC__)
#  define NORETURN __attribute__((noreturn))
#elif defined(__LCLINT__)
#  define NORETURN /*@noreturn@*/ x
#else                           /* !__GNUC__ && !__LCLINT__ */
#  define NORETURN
#endif                          /* !__GNUC__ && !__LCLINT__ */

#ifdef UNUSED
/* nothing */
#elif defined(__GNUC__)
#  define UNUSED(x) x __attribute__((unused))
#elif defined(__LCLINT__)
#  define UNUSED(x) /*@unused@*/ x
#else				/* !__GNUC__ && !__LCLINT__ */
#  define UNUSED(x) x
#endif				/* !__GNUC__ && !__LCLINT__ */


struct dcc_hostdef;


int str_endswith(const char *tail, const char *tiger);
int argv_contains(char **argv, const char *s);

/* exec.c */
int dcc_redirect_fds(const char *stdout_file,
                     const char *stderr_file);
void dcc_run_here(char **argv) NORETURN;
int dcc_spawn_child(char **argv, pid_t *pidptr, const char *, const char *);
int dcc_wait_child(pid_t pid, int *wait_status);
int dcc_critique_status(int s, const char *, const char *);
void dcc_note_execution(const char *hostname, char **argv);


/* arg.c */
int dcc_is_source(const char *sfile);
int dcc_is_preprocessed(const char *sfile);
char * dcc_find_extension(char *sfile);
int dcc_deepcopy_argv(char **, /*@relnull@*/ char ***);
int dcc_shallowcopy_argv(char **, /*@relnull@*/ char ***, int);
int dcc_set_action_opt(char **, char *);
int dcc_set_output(char **, char *);
int dcc_set_input(char **, char *);
int dcc_scan_args(char *argv[], /*@out@*/ /*@relnull@*/ char **orig_o,
                  /*@out@ @relnull@*/ char **orig_i);
char *dcc_argv_tostr(char **a);
char * dcc_preproc_exten(const char *e);

int dcc_argv_len(char **a);

/* clinet.c */
int dcc_cli_connect(const char *host);

/* dopt.c */
int distccd_parse_options(int argc, const char *argv[]);

/* where.c */
int dcc_pick_buildhost(char **buildhost);

/* tempfile.c */
const char *dcc_get_tempdir(void);
int dcc_setup_tempdir(void);
void dcc_cleanup_tempfiles(void);
char *dcc_make_tmpnam(const char *, const char *suffix);

/* serve.c */
int dcc_accept_job(int fd);

/* srvnet.c */
void dcc_log_clientname(int fd);

/* help.c */
int dcc_show_copyright(void);
int dcc_show_version(const char *prog);

/* daemon.c */
void dcc_become_daemon(void);
void dcc_inetd_server(void) NORETURN;
void dcc_server_child(int) NORETURN;

/* dparent.c */
void dcc_standalone_server(void) NORETURN;


/* bulk.c */
int dcc_open_read(const char *fname, int *ifd, off_t *fsize);


/* hosts.c */
int dcc_parse_hosts(struct dcc_hostdef **, int *);
