/* -*- c-file-style: "java"; indent-tabs-mode: nil -*-
 * 
 * distcc -- A simple distributed compiler system
 * $Header: /data/cvs/distcc/src/h_hosts.c,v 1.3 2002/06/21 09:48:06 mbp Exp $ 
 *
 * Copyright (C) 2002 by Martin Pool <mbp@samba.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


/**
 * @file
 *
 * Test harness for hosts.c.
 *
 * Precondition: DISTCC_HOSTS set in the environment.
 *
 * Action: calls the environment parser.
 *
 * Output: on the first line, the number of hosts.  Then, one per
 * line, either
 *
 * "ssh" USER HOST COMMAND
 * "tcp" HOST PORT
 **/


#define _GNU_SOURCE

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <assert.h>
#include <string.h>
#include <errno.h>
#include <time.h>

#include "distcc.h"
#include "trace.h"
#include "util.h"
#include "hosts.h"

const char *rs_program_name = "h_hosts";

int main(int argc, char **argv)
{
    struct dcc_hostdef *list, *e;
    int nhosts, i;

    if (argv[1] && !strcmp(argv[1], "-v")) {
        rs_trace_set_level(RS_LOG_DEBUG);
    }
    
    if (dcc_parse_hosts(&list, &nhosts)) {
        rs_log_error("failed to parse \"%s\"", getenv("DISTCC_HOSTS"));
        exit(1);
    }

    printf("%d\n", nhosts);
    for (i = 0, e = list; i < nhosts; i++, e = e->next) {
        if (!e) {
            rs_log_error("entry %d is NULL", i);
            exit(1);
        }
        
    }
    if (e) {
        rs_log_error("extra entries in list!");
        exit(1);
    }
    
    exit(0);
}
