/* -*- c-file-style: "java"; indent-tabs-mode: nil -*-
 * 
 * distcc -- A simple distributed compiler system
 * $Header: /data/cvs/distcc/src/hosts.c,v 1.4 2002/06/21 09:48:06 mbp Exp $ 
 *
 * Copyright (C) 2002 by Martin Pool <mbp@samba.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


                /* The lyf so short, the craft so long to lerne.
                 * -- Chaucer */


    
/**
 * @file
 *
 * Routines to parse <tt>$DISTCC_HOSTS</tt>.  Actual decisions about
 * where to run a job are in where.c.
 *
 * The grammar of this variable is, informally:
 *
 * DISTCC_HOSTS = HOST ...
 * HOST = SSH_HOST | TCP_HOST
 * SSH_HOST = USER@HOST[:COMMAND]
 * TCP_HOST = HOST[:PORT]
 * HOST = HOSTNAME | IPV4 | '['IPV6']'
 *
 * Any amount of whitespace may be present between hosts.
 *
 * The command specified for SSH defines the location of the remote
 * server, e.g. "/usr/local/bin/distccd".  This is provided as a
 * convenience who have trouble getting their PATH set correctly for
 * sshd to find distccd, and should not normally be needed.
 *
 * If you need to specify special options for ssh, they should be put
 * in ~/.ssh/config and referenced by the hostname.
 *
 * The TCP port defaults to 4200 and should not normally need to be
 * overridden.
 *
 * IPv6 literals are not supported yet.  They will need to be
 * surrounded by square brackets because they may contain a colon,
 * which would otherwise be ambiguous.  This is consistent with other
 * URL-like schemes.
 */

#define _GNU_SOURCE

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <assert.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <ctype.h>

#include "distcc.h"
#include "trace.h"
#include "util.h"
#include "hosts.h"


/* @todo Write and use a test harness for this. */

/**
 * @post *ret_nhosts>0 if the function succeeded.
 *
 * @post There are @p *ret_nhosts entries in the list at @p *ret_list.
 *
 * @return -1 on error (including no hosts defined), or 0
 **/
int dcc_parse_hosts(struct dcc_hostdef **ret_list,
                    int *ret_nhosts)
{
    char *where;
    struct dcc_hostdef *prev, *curr;

    where = getenv("DISTCC_HOSTS");
    if (!where || !*where) {
        rs_log_warning("$DISTCC_HOSTS is empty or undefined; can't distribute work");
        return -1;
    }

    prev = NULL;
    /* A simple, hardcoded scanner.  Some of the GNU routines might be
     * useful here, but they won't work on less capable systems.
     *
     * We repeatedly attempt to extract a whitespace-delimited host
     * definition from the string until none remain.  Allocate an
     * entry; hook to previous entry.  We then determine if there is a
     * '@' in it, which tells us whether it is an SSH or TCP
     * definition.  We then duplicate the relevant subcomponents into
     * the relevant fields. */
    while (1) {
        int token_len;
        char *token_start;
        int has_at;
        
        while (isspace(where[0]))
            where++;            /* skip space */
        if (where[0] == '\0')
            break;              /* end of string */

        token_start = where;
        token_len = strcspn(where, " ");

        has_at = (memchr(token_start, '@', token_len) != NULL);
        /* TODO: Call a separate function to split each type up, then
         * link the result into the list. */
        if (has_at) {
            rs_trace("found ssh token \"%.*s\"", token_len, token_start);
        } else {
            rs_trace("found tcp token \"%.*s\"", token_len, token_start);
        }

        where = token_start + token_len;
    }
    
    return -1;
}

