/* -*- c-file-style: "java"; indent-tabs-mode: nil;  -*-
 * 
 * distcc -- A simple distributed compiler system
 *
 * Copyright (C) 2002, 2003 by Martin Pool <mbp@samba.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <netdb.h>

#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/param.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <netinet/tcp.h>

#ifdef HAVE_ARPA_NAMESER_H
#  include <arpa/nameser.h>
#endif

#include <arpa/inet.h>

#ifdef HAVE_RESOLV_H
#  include <resolv.h>
#endif

#include <netdb.h>

#include "types.h"
#include "exitcode.h"
#include "distcc.h"
#include "trace.h"
#include "util.h"
#include "srvnet.h"
#include "access.h"
#include "netutil.h"


#ifdef ENABLE_RFC2553
int dcc_sockaddr_to_ip(struct sockaddr *sa,
                       int sa_len,
                       char **p_buf)
{
    int err;
    char host[200];

    err = getnameinfo(sa, sa_len,
                      host, sizeof host,
                      NULL, 0,
                      NI_NUMERICHOST | NI_NUMERICSERV);
    if (err) {
        rs_log_error("getnameinfo failed: %s", gai_strerror(err));
        *p_buf = strdup("(UNKNOWN)");
        return EXIT_DISTCC_FAILED; /* more specific? */
    }

    *p_buf = strdup(host);

    return 0;
}
#else /* ndef ENABLE_RFC2553 */
int dcc_sockaddr_to_ip(struct sockaddr *sa,
                       int UNUSED(sa_len),
                       char **p_buf)
{
    *p_buf = strdup(inet_ntoa(((struct sockaddr_in *) sa)->sin_addr));
    return 0;
}
#endif /* ndef ENABLE_RFC2553 */
