/* --------------------------------- grstat.c ------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Display video driver statistics.
*/

#include "fly.h"


Ulong	far GrStats[2048] = {0};

static Uchar *
edit_l (Ulong n, char *s, Ulong f)
{
	int	i, j;
	int	k[20];
	char	line[100];

/* break number into digits
*/
	for (i = 0; i < rangeof(k); ++i) {
		k[i] = (int)(n % 10);
		n /= 10;
	}

/* multiply by factor
*/
	if (f) {
		n = 0;
		for (i = 0; i < rangeof(k); ++i) {
			n += k[i] * f;
			k[i] = (int)(n % 10);
			n /= 10;
		}
	}

/* Print prefix
*/
	j = 0;
	if (s) {
		while (*s)
			line[j++] = *s++;
	}

/* Find highest digit
*/
	for (i = rangeof(k); --i > 0 && 0 == k[i];)
		;

/* Print number
*/
	for (; i >= 0; --i) {
		line[j++] = (char)('0' + k[i]);
		if (i && !(i%3))
			line[j++] = ',';
	}
	line[j] = '\0';

	return ((Uchar *)line);
}

static Uchar *
show_ul (Ulong l)
{
	return (edit_l (l, NULL, 0L));
}

static Uchar *
show_ulf (Ulong l, Ulong f)
{
	return (edit_l (l, NULL, f));
}

extern void far
bLogStats (void)
{
	int	i;
	Ulong	sp, sl, l, p, t;

	l = 0;
	for (i = 0; i < 2048; ++i) {
		if (l < GrStats[i])
			l = GrStats[i];
	}
	sp = sl = 1L;
	if        (l >= 1000000000L) {
		sp = 1000L;
		sl = 100L;
	} else if (l >= 100000000L) {
		sp = 100L;
		sl = 10L;
	} else if (l >= 10000000L)
		sp = 10L;

	l = p = 0L;
	printf ("Line drawing summary:\n");
	printf ("  len          count              volume\n");
	for (i = 0; i < 2048; ++i) {
		if (GrStats[i]) {
			printf (" %4u %14s", i, show_ul (GrStats[i]));
			printf (" %19s\n", show_ulf (GrStats[i], (Ulong)i));
			l += GrStats[i]/sl;
			p += GrStats[i]/sp*i;
		}
	}
	printf ("  tot %14s", show_ulf (l, sl));
	printf (" %19s\n", show_ulf (p, sp));
}
