/*
** This takes a directory full of 16x16 XPM images and merges them into
** a single large RAW image.
**
** Each XPM's position inside the map is given by the 3 digit name
** of the form NNN.xpm. All unspecified positions are filled by the
** default file DEFAULT.xpm.
**
** The resulting large file is written out as IMAGEDIR.PPM
*/

/*
** Pass the name of the directory to process
*/

#include "game.h"

unsigned short data[256*256];

main(int argc, char *argv[])
	{
	char fname[32];
	char basename[32];
	GrObject *dc;
	GrObject *pic;
	int i,j,n,x,y,row,col,rotate=0;
	int max_entry=0,ntiles;
	FILE *z;
	
	/* Do we generate the 4 90-degree rotations as well ? */
	if (argc==3 && !strcmp(argv[2],"-rotate")) rotate=1;

	sprintf(fname,"%s/default.xpm",argv[1]);
	if (access(fname,R_OK))
	   Die("No \"default.xpm\" tile in %s\n",argv[1]);

	strcpy(basename,argv[1]); strcat(basename,".raw");

	GrInit(640,480,16);
	dc = GrCreateObject(256*16,16);

	pic = XpmReadFileToGrObject(fname,"../rgb.txt");
	if (pic==NULL) Die("Could not load %s\n",fname);

	for(row=0; row<256; row+=16) for(col=0; col<256; col+=16)
	   GrDrawObjectNC(pic,col,row);

	for(col=0; col<256*16; col+=16) 
	   GrMergeObjectNC(dc,pic,col,0,GrWRITE);

	for(i=0; i<256; ++i)
	   {
	   sprintf(fname,"%s/%d.xpm",argv[1],i);
	   row = i&0xf0; col = (i & 0xf)<<4;

	   if (access(fname,R_OK)) continue;

	   pic = XpmReadFileToGrObject(fname,"../rgb.txt");
	   if (pic == NULL) continue;
	   j=0; again:
	   GrDrawObjectNC(pic,col,row);
	   n = row + (col>>4); if (n>max_entry) max_entry = n;
	   GrMergeObjectNC(dc,pic,n*16,0,GrWRITE);
	   if (rotate && ++j < 4) {do_rotate(pic,&row,&col); goto again;}
	   }

	/* Now dump the result as a single raw image */
	z = fopen(basename,"wb");
	if (z==NULL) Die("Cannot open %s for writing\n",basename);

	ntiles = max_entry+1;
	for(n=y=0; y<16; ++y) for(x=0; x<ntiles*16; ++x,++n)
	   data[n] = GrPixelNC(dc,x,y);

	n<<=1; /* convert n from pixels into bytes */
	if (fwrite((char *)data,1,n,z) != n)
	   Die("Error writing %s: short write\n",basename);

	fclose(z);
	GrShutdown();
	exit(0);
	}

int do_rotate(GrObject *gc, int *row, int *col)
	{
	int x,y,i,val;
	unsigned short data[256];

	/* Rotate the image by 90 degrees clockwise */
	for(y=i=0; y<16; ++y) for(x=0; x<16; ++x) data[i++] = GrPixelNC(gc,x,y);
	for(i=0,x=15; x>=0; --x) for(y=0; y<16; ++y) GrPlotNC(gc,x,y,data[i++]);

	/* Now shift the bitmap left by 2, rotating about 8 bits boundary */
	i = *row + ((*col)>>4);
	i<<=2; val = (i&0xff) | (i>>8);
	*row = val&0xf0; *col = (val & 0xf)<<4;
	return 0;
	}
