#include "game.h"

/*
** Landscape.c : This module is used to populate a newly-created terrain
** 		 file with an "interesting" landscape
*/

static void ReprocessWater(int y, int x);
static void create_special_areas(void);

int
iswater(x,y)
	{
	int t = Get_TerrainType(y,x);
	if (t == T_SHALLOW_WATER || t == T_DEEP_WATER || t == T_SURFACE_WATER)
	   return 1;
	return 0;	
	}

void
Create_Landscape()
	{
	int row,col;
	unsigned v,t,npd;

	/* npd is the number of T_PACKED_DIRT variation tiles */
	npd = NumVarTiles(T_PACKED_DIRT);

	/* Initial landscape is just dirt */
	for(row = 0; row < CELLS_DOWN; ++row)
	   {
	   Print(0,30,"Row: %d",row);
	   for(col = 0; col < CELLS_ACROSS; ++col)
	    	Set_TerrainTypeIndex(row,col,T_PACKED_DIRT,Random(npd));
	   }

	Print(1,0,"Creating Lakes:");
	create_lakes();

	Print(1,0,"Creating Specials:");
	create_special_areas();

	/*
	** Reprocess the world to lay down correct tiles for water etc
	*/
	Print(1,0,"Reprocessing...");
	for(row = 0; row < CELLS_DOWN; ++row)
	   {
	   Print(0,30,"Row: %-4d",row);
	   for(col = 0; col < CELLS_ACROSS; ++col)
		   if (Get_TerrainType(row,col) == T_DEEP_WATER)
		       ReprocessWater(row,col);
	   }

	return;
	}

static void
ReprocessWater(int y, int x)
	{
	int i,n;
	int dx[8] = {-1,-1,0,1,1,1,0,-1};
	int dy[8] = {0,-1,-1,-1,0,1,1,1};
	unsigned int rval;

	rval=0;
	for(i=0; i<8; ++i)
	   {
	   n = Get_TerrainType(y+dy[i],x+dx[i]);
	   if (n != T_SHALLOW_WATER && n != T_DEEP_WATER)
		rval |= (1<<i);
	   }
	if (rval == 0) /* water on all sides, leave it as DEEP WATER */
	return;

	/* Otherwise, rval is an index into the tiles for SHALLOW_WATER */
	Set_TerrainTypeIndex(y,x,T_SHALLOW_WATER,rval);
	return;
	}

/************************************************************************/

static struct
	{
	int type;
	int prob;
	} areas[] = {
		{A_DESERT,0},
		{A_SWAMP,10},
		{A_VILLAGE,0},
		{A_FOREST,0},
		{-1,-1}};

static void
create_special_areas()
	{
	int i,j,r,total,*a;
	int n,t;

	for(i=total=0; areas[i].type>=0; ++i) total+=areas[i].prob;

	/* Allocate proportional space for each type */
	a = (int *) malloc(total * sizeof(int));
	if (a==NULL) Die("Malloc error");
	i=j=0; while(areas[i].type>=0)
	   {
	   n = areas[i].prob; while(n--) a[j++] = areas[i].type;
	   ++i;
	   }

	n = 5 + Random(5);
	while(n--)
	   {
	   switch(a[Random(total)])
		{
/*
		case A_DESERT: create_desert(); break;
		case A_VILLAGE: create_village(); break;
		case A_FOREST: create_forest(); break;
*/
		case A_SWAMP: create_swamp(); break;
		}
	   }
	free(a);
	}
