/*
** Game parameters
*/

#define IMAGEDIR 	"Images"

#define PIX_WIDTH	65536
#define PIX_HEIGHT	65536
#define PIXEL_BYTES	2
#define CELL_SIZE	16
#define CELL_BYTES	2
#define CELLS_ACROSS	(PIX_WIDTH/CELL_SIZE)
#define CELLS_DOWN	(PIX_HEIGHT/CELL_SIZE)
#define NUM_CELLS	(CELLS_ACROSS * CELLS_DOWN)
#define REGION_WIDTH	256
#define REGION_HEIGHT	256
#define REGION_SIZE	(REGION_WIDTH * REGION_HEIGHT)
#define REGION_BYTES	(REGION_SIZE * CELL_BYTES)
#define REGION_SLICE	(REGION_BYTES >> 3)

#define NUM_REGIONS	(NUM_CELLS / REGION_SIZE)

#define REGIONS_ACROSS	(CELLS_ACROSS / REGION_WIDTH)
#define SCREEN_WIDTH 	1024
#define SCREEN_HEIGHT 	768
#define SCREEN_DEPTH	16

#define MAP_WIDTH	1024
#define MAP_HEIGHT	640

#define MAP_CELLS_ACROSS 	(MAP_WIDTH / CELL_SIZE)
#define MAP_CELLS_DOWN		(MAP_HEIGHT / CELL_SIZE)

#define CHAR_WIDTH	8
#define CHAR_HEIGHT	16

#define TEXT_TOP	(MAP_HEIGHT + 4)
#define TEXT_ROWS	((SCREEN_HEIGHT - MAP_HEIGHT) / CHAR_HEIGHT)

#define PLATECELLWIDTH	20
#define PLATECELLHEIGHT 8
#define PLATEPIXWIDTH	(CELL_SIZE*PLATECELLWIDTH)	/* pixels */
#define PLATEPIXHEIGHT  (CELL_SIZE*PLATECELLHEIGHT)
#define PLATES_ACROSS	((MAP_WIDTH)/(PLATEPIXWIDTH)+2)
#define PLATES_DOWN	((MAP_HEIGHT)/(PLATEPIXHEIGHT)+1)
#define NPLATES		((PLATES_ACROSS)*(PLATES_DOWN))

#define NPLANES		4	/* Sprite planes for animation */
/*
** Terrains
*/

#define T_LOOSE_DIRT	0
#define T_PACKED_DIRT	1
#define T_PAVED		2
#define T_CLAY		3
#define T_SHORT_ROCK	4
#define T_TALL_ROCK	5

#define T_SHORT_GRASS	6
#define T_LONG_GRASS	7

#define T_LOOSE_SAND	8
#define T_PACKED_SAND	9
#define T_LOOSE_GRAVEL	10
#define T_MUD		11
#define T_QUAGMIRE	12

#define T_SURFACE_WATER	13
#define T_SHALLOW_WATER	14
#define T_DEEP_WATER	15

#define T_SHRUB		16
#define T_SHORT_TREE	17
#define T_TALL_TREE	18

#define T_BLANK		123
#define T_UNDEFINED	124

/*
** Standard colours
*/
#define BLACK 		0
#define WHITE		1
#define RED		2
#define GREEN		3
#define BLUE		4
#define DARK_GREY	5
#define LIGHT_GREY	6
#define DARK_RED	7
#define DARK_GREEN	8
#define DARK_BLUE	9
#define YELLOW		10
#define PINK		11
#define LIGHT_GREEN	12
#define LIGHT_BLUE	13
#define ORANGE		14
#define BROWN		15
#define GREY		16

/*
** Definitions of different areas of the map
*/
#define A_SWAMP		0
#define A_DESERT	1
#define A_FOREST	2
#define A_VILLAGE	3

#define ESC	27

#define SYSTEM_TILE	0
#define TRANSPARENT_BIT 	0x00000020
#define TRANSPARENT_BIT_2PIXELS 0x00200020
#define TRANSPARENT_BIT_HIGH	0x00200000

/*
** Definitions pertaining to Entities
*/
#define E_RELATIVE 	1
#define E_ABSOLUTE 	2
#define E_ALLPLANES	3

/*
** Key definitions
*/
#define KEY_NONE	0
#define KEY_a		1
#define KEY_b		2
#define KEY_c		3
#define KEY_d		4
#define KEY_e		5
#define KEY_f		6
#define KEY_g		7
#define KEY_h		8
#define KEY_i		9
#define KEY_j		10
#define KEY_k		11
#define KEY_l		12
#define KEY_m		13
#define KEY_n		14
#define KEY_o		15
#define KEY_p		16
#define KEY_q		17
#define KEY_r		18
#define KEY_s		19
#define KEY_t		20
#define KEY_u		21
#define KEY_v		22
#define KEY_w		23
#define KEY_x		24
#define KEY_y		25
#define KEY_z		26
#define KEY_A		27
#define KEY_B		28
#define KEY_C		29
#define KEY_D		30
#define KEY_E		31
#define KEY_F		32
#define KEY_G		33
#define KEY_H		34
#define KEY_I		35
#define KEY_J		36
#define KEY_K		37
#define KEY_L		38
#define KEY_M		39
#define KEY_N		40
#define KEY_O		41
#define KEY_P		42
#define KEY_Q		43
#define KEY_R		44
#define KEY_S		45
#define KEY_T		46
#define KEY_U		47
#define KEY_V		48
#define KEY_W		49
#define KEY_X		50
#define KEY_Y		51
#define KEY_Z		52
#define KEY_0		53
#define KEY_1		54
#define KEY_2		55
#define KEY_3		56
#define KEY_4		57
#define KEY_5		58
#define KEY_6		59
#define KEY_7		60
#define KEY_8		61
#define KEY_9		62
#define KEY_ESC		63
#define KEY_L_ARROW	64
#define KEY_R_ARROW	65
#define KEY_U_ARROW	66
#define KEY_D_ARROW	67
#define KEY_F1		68
#define KEY_F2		69
#define KEY_F3		70
#define KEY_F4		71
#define KEY_F5		72
#define KEY_F6		73
#define KEY_F7		74
#define KEY_F8		75
#define KEY_F9		76
#define KEY_F10		77
#define KEY_SPACE	78
