#include "game.h"
#include "libgif/gif_lib.h"

static int
    BackGround = 0,
    ColorMapSize = 0,
    InterlacedOffset[] = { 0, 4, 2, 1 }, /* The way Interlaced image should. */
    InterlacedJumps[] = { 8, 8, 4, 2 };    /* be read - offsets and jumps... */

static GifColorType *ColorMap;

#define MAXGIFS		256

static GrObject *Gifs[MAXGIFS];
static int ngifs = 0;

GrObject *
LoadGif(char *file)
	{
    	int i,j,Error, Size, Row, Col, Width, Height, ExtCode, Count;
	unsigned short sh;
	int o,n;
    	GifRecordType RecordType;
    	GifByteType *Extension;
    	unsigned char *rowbuffer;
    	GifFileType *gf;
    	GifColorType *cm;
	GrObject *gif;

	/*
	** Have we loaded too many GIFs already?
	*/
	if (ngifs == MAXGIFS) Die("LoadGif: Too many GIFs");

	/*
	** Have we loaded this gif already ?
	*/
	for(i=0; i<ngifs; ++i)
	   if (Gifs[i]->name && !strcmp(Gifs[i]->name,file))
		return Gifs[i];

    	if ((gf = DGifOpenFileName(file)) == NULL)
	   {
	   PrintGifError();
	   Die("LoadGif: DGifOpenFileName(%s) failed\n",file);
	   }

	Gifs[ngifs] = GrCreateObject(gf->SWidth,gf->SHeight);
	if (Gifs[ngifs] == NULL) Die("LoadGif: GrCreateObject failed");
	gif = Gifs[ngifs];

	if ((gif->name = malloc(strlen(file)+1)) == NULL)
	   Die("LoadGif: Out of memory\n");
	strcpy(gif->name,file);

	rowbuffer = malloc(gif->Width * gif->Height);
	if (rowbuffer == NULL)
	   Die("LoadGif: Out of memory\n");
	for(i=gif->Width*gif->Height-1; i>=0; --i) rowbuffer[i]=0;

    	ColorMap = (gf -> IColorMap ? gf -> IColorMap :
				       gf -> SColorMap);
    	ColorMapSize = 1 << (gf -> IColorMap ? gf -> IBitsPerPixel :
				                gf -> SBitsPerPixel);

    	/* Scan the content of the GIF file and load the image(s) in: */
    	do
	   {
	   if (DGifGetRecordType(gf, &RecordType) == GIF_ERROR) 
		{
	    	PrintGifError();
	    	Die("LoadGif: DGifGetRecordType failed");
		}

	   switch (RecordType) {
	      case IMAGE_DESC_RECORD_TYPE:
		if (DGifGetImageDesc(gf) == GIF_ERROR) {
		    PrintGifError();
		    Die("LoadGif: DGifGetImageDesc failed");
		}
		Row = gf -> ITop; /* Image Position relative to Screen. */
		Col = gf -> ILeft;
		Width = gf -> IWidth;
		Height = gf -> IHeight;
		if (gf -> ILeft + gf -> IWidth > gf -> SWidth ||
		   gf -> ITop + gf -> IHeight > gf -> SHeight) {
		    Log("LoadGif: Image %d is not confined to screen dimension, aborted.\n");
		       return NULL;
		}
		if (gf -> IInterlace) {
		    /* Need to perform 4 passes on the images: */
		    for (Count = i = 0; i < 4; i++)
			for (j = Row + InterlacedOffset[i]; j < Row + Height; j += InterlacedJumps[i]) 
			   {
			    if (DGifGetLine(gf, rowbuffer, Width) == GIF_ERROR)
				{ PrintGifError(); return NULL; }

			   /* Copy the byte (palette) row into the RGB row */
			   for (o = j * gif->Width + Col,n=0; n<Width; ++n,++o)
				{
				cm = & ColorMap[rowbuffer[n]];
				gif->data[o] = (ushort)(cm->Red>>3); 
				gif->data[o] = (ushort)((gif->data[o]<<5) | (cm->Green>>3));
				gif->data[o] = (ushort)((gif->data[o]<<6) | (cm->Blue>>3));
				}
			   }
		}
		else {
		    for (i = 0; i < Height; i++,++Row)
			{
			if (DGifGetLine(gf,rowbuffer,Width) == GIF_ERROR)
				{
			    	PrintGifError();
			    	return NULL;
				}

			/* Copy the byte (palette) row into the RGB row */
			for (o = Row * gif->Width + Col,n=0; n<Width; ++n,++o)
				{
				cm = & ColorMap[rowbuffer[n]];
				gif->data[o] = (ushort)(cm->Red>>3); 
				gif->data[o] = (ushort)((gif->data[o]<<5) | (cm->Green>>3));
				gif->data[o] = (ushort)((gif->data[o]<<6) | (cm->Blue>>3));
				}
		       }
		}
		break;
	    case EXTENSION_RECORD_TYPE:
		/* Skip any extension blocks in file: */
		if (DGifGetExtension(gf, &ExtCode, &Extension) == GIF_ERROR) {
		    PrintGifError();
		    return NULL;
		}
		while (Extension != NULL) {
		    if (DGifGetExtensionNext(gf, &Extension) == GIF_ERROR) {
			PrintGifError();
			return NULL;
		    }
		}
		break;
	    case TERMINATE_RECORD_TYPE:
		break;
	    default:		    /* Should be traps by DGifGetRecordType. */
		break;
	}
    }
    while (RecordType != TERMINATE_RECORD_TYPE);

    if (DGifCloseFile(gf) == GIF_ERROR) 
	{
	PrintGifError();
	Die("LoadGif: DGifCloseFile failed");
    	}

   free(rowbuffer); ++ngifs;
   return gif;
   }

int
NumImages()
	{
	return ngifs;
	}

/*
** In 15 bit colour mode (5-5-5) we use the top bit to indicate a
** "Transparent" colour.
*/
void
GifMapColourToBg(GrObject *g, int c)
	{
	int x,y,n;

	for(y=n=0; y < g->Height; ++y) for(x=0; x<g->Width; ++x,++n)
	   if (g->data[n] == c) g->data[n] |= TRANSPARENT_BIT;
	}
