/*
** Reads a GIF compatible file and writes out a raw 16 bpp file with the
** suffix ".RAW"
*/

/*
** Pass the name of the directory to process
*/

#include "game.h"

unsigned short data[256*256];

main(int argc, char *argv[])
	{
	char fname[64];
	GrObject *dc;
	GrObject *gif;
	int n;
	FILE *z;
	
	strcpy(fname,argv[1]);

	GrInit(640,480,15);

	gif = LoadGif(fname);
	if (gif == NULL) Die("%s: Not a valid GIF image",fname);
	for(n=strlen(fname); n && fname[n-1] != '.'; --n);
	strcpy(&fname[n],"raw");

	z = fopen(fname,"wb");
	if (z==NULL) Die("Cannot open %s for writing\n",fname);

	n = gif->Width * gif->Height * 2;	/* number of bytes */
	if (fwrite((char *)gif->data,1,n,z) != n)
	   Die("Error writing %s: short write\n",fname);

	fclose(z);
	GrShutdown();
	exit(0);
	}
