#ifndef USE_JUGL
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/extensions/xf86dga.h>
#include <X11/extensions/xf86vmode.h>
#include <sys/mman.h>
#else
#include <stddef.h>
#endif

#define GrWRITE		0
#define GrOR		1
#define GrXOR		2
#define GrIMAGE		3
#define GrAND		4

typedef struct
	{
	char *name;			/* Optional ascii name for object */
	char *mem;			/* ptr returned by malloc() */
	unsigned short *data;		/* Image data for object */
	int Width,Height;
	int PixelsPerLine;
	int mapped;		/* 1 if object is mapped */
	int x,y;		/* If mapped, (x,y) is onscreen coords */
	} GrObject;

#define Clip1D(x,min,max) ((x)<=(min) ? (min) : ((x)>=(max) ? (max) : x))

#define GrPlotNC(g,x,y,c) ((g)->data[(g)->PixelsPerLine*(y) + x] = (c))
#define GrPlot(g,x,y,c) ((g)->data[(g)->PixelsPerLine*(Clip1D(y,0,(g)->Height-1)) + \
				Clip1D(x,0,(g)->Width-1)] = (c))

#define GrPixelNC(g,x,y) ((g)->data[(g)->PixelsPerLine*(y) + x])
#define GrPixel(g,x,y) ((g)->data[(g)->PixelsPerLine*(Clip1D(y,0,(g)->Height-1)) + \
				Clip1D(x,0,(g)->Width-1)])

int GrInit(int,int,int);
void GrShowFrame(void);
void GrNextFrame(void);
void GrSetDrawingRegion(int,int,int,int);
void GrShutdown(void);
GrObject *GrCreateObject(int,int);
void GrDestroyObject(GrObject *);

/* Misc. drawing routines */
void GrSolidFill(int,int,int,int,ushort);
void GrSolidFillNC(int,int,int,int,ushort);
void GrScreenPlot(int,int,int);
void GrScreenPlotNC(int,int,int);

/* Object -> Object routines */
void GrFillObject(GrObject *, ushort);
void GrMergeObject(GrObject *, GrObject *, int,int,int);
void GrMergeObjectNC(GrObject *, GrObject *, int,int,int);
void GrMergeObjectSubSection(GrObject *, GrObject *, int,int, int,int,int,int, int);
void GrMergeObjectSubSectionNC(GrObject *, GrObject *, int,int, int,int,int,int, int);

/* Object -> Screen routines */
void GrDrawObject(GrObject *, int,int);
void GrDrawObjectNC(GrObject *, int,int);
void GrDrawObjectSubSection(GrObject *, int,int, int,int,int,int);
void GrDrawObjectSubSectionNC(GrObject *, int,int, int,int,int,int);


/***************************************************************************/

#ifndef USE_JUGL
extern Display *dpy;
#endif

extern int _GrLineOffsetB,_GrLineOffsetW,_GrLineOffsetL,_GrLineOffsetQ;
extern int _GrXMAX, _GrYMAX, _GrXMIN, _GrYMIN;
