#include "game.h"

void
create_lakes()
	{
	int num_lakes;
	int sx,sy;

	num_lakes = 200 + Random(20);
	while(num_lakes--)
	   {
	   /* Determine top left corner for lake */
	   sx = Random(CELLS_ACROSS);
	   sy = Random(CELLS_DOWN);
	   Print(1,20,"Lake at %-4d,%-4d",sx,sy);
	   switch(Random(3))
	   	{
		case 0: create_lake('v',sx,sy); break;
		case 1: create_lake('h',sx,sy); break;
		case 2: create_lake('c',sx,sy); break;
		}
	   }
	}

void
create_lake(int which, int sx, int sy)
	{
	/*
	** Create a lake starting at (sx,sy) which is of greatest extent in
	** the vertical direction.
	*/
	int max_width, max_length;
	int cur_width, cur_length;
	int i,x,y,rx,ry,dw,w,dx,dy,rstartx,rstarty,x1,y1;
	int lx,ly;

	Log("Lake %d %d\n",sx,sy);

	switch(which)
	   {
	   case 'v': 
		/* Vertical lake */
		max_width = Random(20) + 20;
		max_length = Random(40) + 20;
		dx = 1; dy = 0; ry=1; rx=0;

		/* Lake centre coords (approximately) */
		lx = sx; ly = sy + max_length/2;
		break;
	   case 'h': 
		/* Horizontal lake */
		max_width = Random(40) + 20;
		max_length = Random(20) + 20;
		dx = 0; dy = 1; ry=0; rx=1;

		/* Lake centre coords (approximately) */
		lx = sx + max_length/2; ly = sy;
		break;
	   default:
		/* Anything else (circular, for example) */
		max_width = Random(30) + 20;
		max_length = Random(30) + 20;
		dx = 0; dy = 1; ry=0; rx=1;

		/* Lake centre coords (approximately) */
		lx = sx + max_length/2; ly = sy;
		break;
	   }

	w = 0; cur_length=0; cur_width=0;
	rstartx=rstarty=-1;
	while(cur_length <= max_length || w>3)
	   {
	   /* Determine a change in width for this row */
	   dw = 1 - Random(3);
	   if (cur_length < max_length/2) dw += Random(2);
	   else dw -= Random(2);
	   w += dw; if (w<1) w=1; if (w>max_width) w=max_width;

	   if (which == 'h' || which=='c')
		{
		x = sx;
	   	y = sy - w/2 + 1 - Random(3);
		}
	   else
		{
	   	x = sx - w/2 + 1 - Random(3);
		y = sy;
		}

	   x1 = x; y1 = y;
	   for(i=1; i<w-1; ++i,x+=dx,y+=dy)
		Set_TerrainTypeIndex(y,x,(uint)T_DEEP_WATER,0);
	   sy+=ry; sx+=rx; ++cur_length;
	   }

	/* Now add a river to this lake */
	River(lx,ly,1,50+max_width+max_length+Random(128));
	}
