#include "game.h"

main(int argc, char *argv[])
	{
	int i,n,ispress,key,lshift_key,rshift_key,shift=0;
	unsigned long last,current;
	int count=0,finished=0;
	int fx,fy,x,y,dx,dy,eid[4];
	int keycode[256];
	GrObject *gr;

	InitGraphics();

	if (argc == 3 && !strcmp(argv[1],"-create"))
	   {
	   Set_Terrain_Cache(32);
	   Print(0,0,"Creating terrain file %s\n",argv[2]);
	   Create_Terrain(argv[2]);
	   Create_Landscape();
	   Save_Terrain();
	   GrShutdown();
	   exit(0);
	   }

	Load_Terrain("test.trn");

	x=StartX; y=StartY;

	dx=0; dy=0; count=0; current=last=time(NULL);
	SetMapCentre((int)x,(int)y);
	RedrawMap();

	n=4;
	for(i=0; i<2; ++i) eid[i] = drawat("xpmtest",x+50*i,y+50*i,i);
	for(; i<n; ++i) eid[i] = drawat("extra",x+50*i,y+50*i,i);

	for(i=0; i<256;++i) keycode[i]=0;
GrKeycode(&keycode[KEY_h],"h");
GrKeycode(&keycode[KEY_j],"j");
GrKeycode(&keycode[KEY_k],"k");
GrKeycode(&keycode[KEY_l],"l");
GrKeycode(&lshift_key,"left shift");
GrKeycode(&rshift_key,"right shift");
GrKeycode(&keycode[KEY_ESC],"esc");
GrKeycode(&keycode[KEY_SPACE]," ");
GrKeycode(&keycode[KEY_q],"q");
GrKeycode(&keycode[KEY_L_ARROW],"left");
GrKeycode(&keycode[KEY_R_ARROW],"right");
GrKeycode(&keycode[KEY_U_ARROW],"up");
GrKeycode(&keycode[KEY_D_ARROW],"down");

	while(!finished)
	   {
	   if ((count&7)==0 && (key=GrKeyPress(&ispress)))
		{
		if (key == lshift_key) shift = ispress;
		if (key == rshift_key) shift = ispress;

		if (!ispress) continue;
		for(i=0; i<256; ++i) if (keycode[i] == key) switch(i)
		   {
		   case KEY_ESC: dx=dy=fx=fy=0; x=StartX; y=StartY;
			  SetMapCentre(x,y);
			  RedrawMap(); break;
		   case KEY_h:
		   case KEY_L_ARROW:
				if (!shift) dx-=ScrollInc;
		   		else MapScroll(-ScrollInc,0);
				break;
		   case KEY_l:
		   case KEY_R_ARROW:
				if (!shift) dx+=ScrollInc;
		   		else MapScroll(ScrollInc,0);
				break;
		   case KEY_j:
		   case KEY_D_ARROW:
				if (!shift) dy+=ScrollInc;
				else MapScroll(0,ScrollInc);
				break;
		   case KEY_k:
		   case KEY_U_ARROW:
				if (!shift) dy-=ScrollInc;
				else MapScroll(0,-ScrollInc);
				break;
		   case KEY_p: GrWaitforKeyPress(); break;
		   case KEY_q: finished=1; break;
		   case KEY_d: MoveEntity(0,x,y,E_ABSOLUTE); break;
		   case KEY_r: MapRefresh(); break;
		   case KEY_SPACE: dx=dy=0; break;
	 	   }
		}

	   if (n>0)
	      {
	      MoveEntity(eid[Random(n)],Random(3)-1,Random(3)-1,E_RELATIVE);
	      }
	
	   if (dx||dy) MapScroll(dx,dy);
   	   MapRefresh();
   	   GetMapCentre(&x,&y);

	   ++count;
	   if ((count&7)==0) current=time(NULL);
	   if (current - last >= 1)
		{
		Print(2,0,"%5d  ",count);
	  	Print(0,0,"[%d, %d] (%d,%d)  ",x,y,dx,dy);
		count=0;
		last=current;
		}
	   }
	   
	ShutdownGraphics();
	}

drawat(char *name,int x, int y,int pl)
	{
	static int init=0;
	int sid;

	if (!init)
	   {
	   if (LoadSprites("test.spr") < 1) Die("Error loading sprites");
	   init=1;
	   }

	sid = GetSpriteID(name);
	if (sid<0) Die("Could not locate sprite %s\n",name);

	return CreateEntity(sid,0,x,y,pl);
	}
