#include "parse.h"

static void
CalculateExpressionType(char *, char *, char *);

static instruct **InstructionList;
static int c_iptr=0,m_iptr=0,checkpoint[256],chp=0;

instruct *
BuildInstruction(int opcode,int nargs,char *str,...)
	{
	int i;
	char buf[2048],*ch;
	instruct *iptr;
	va_list arg;

	va_start(arg,str);

	iptr = (instruct *)calloc(1,sizeof(instruct));
	if (iptr == NULL) Fail("Out of memory");

	iptr->opcode = opcode;
	iptr->nargs  = nargs;

	if (str != NULL)
	   {
	   vsprintf(buf,str,arg);
	   ch=strtok(buf," "); i=0;
	   while(ch)
		{
		if (i >= MAX_ARGS) Fail("Too many arguments to opcode: %s",str);
		switch(ch[0])
		   {
		   case '@': iptr->arg[i].loc = LOC_TOS; break;
		   case 's': iptr->arg[i].loc = LOC_STACK;
			     iptr->arg[i].x.val = atoi(ch+1);
				break;
		   case 'g': iptr->arg[i].loc = LOC_GLOBAL;
			     iptr->arg[i].x.str = (char *)malloc(strlen(ch));
			     strcpy(iptr->arg[i].x.str,ch+1);
				break;
		   case 'i': if (isdigit(ch[1]))
				{
				iptr->arg[i].x.val = atoi(ch+1); 
		   		iptr->arg[i].loc = LOC_INTEGER;
				}
			     else
				{
		   		iptr->arg[i].loc = LOC_SIZE_TYPE;
			     	iptr->arg[i].x.str = (char *)malloc(strlen(ch));
			     	strcpy(iptr->arg[i].x.str,ch+1);
				}

			     break;
		   case 'r': iptr->arg[i].loc = LOC_REAL;
			     iptr->arg[i].x.rval = atof(ch+1); 
				break;
		   case 't': iptr->arg[i].loc = LOC_TYPE;
			     iptr->arg[i].x.str = (char *)malloc(strlen(ch));
			     strcpy(iptr->arg[i].x.str,ch+1);
				break;
		   case 'c': iptr->arg[i].loc = LOC_CHAR;
				{
				char buf[2];
			     	sprintf(buf,"%s",ch+1);
			     	iptr->arg[i].x.val = buf[0];
				}
			     break;
		   case 'q': iptr->arg[i].loc = LOC_STRING;
			     iptr->arg[i].x.str = (char *)malloc(strlen(ch));
			     strcpy(iptr->arg[i].x.str,ch+1);
				break;
		   default:  Fail("Unknown opcode specifier: %s",ch); break;
		   }
		ch = strtok(0," "); ++i;
		}
	   }
	va_end(arg);
	return iptr;
	}

void
PushInstruction(instruct *in)
	{
	int i;

	if (c_iptr == m_iptr)
	   {
	   m_iptr += 10;
	   if (InstructionList)
		InstructionList = (instruct **)realloc(InstructionList,m_iptr * sizeof(instruct *));
	   else InstructionList = (instruct **)malloc(m_iptr * sizeof(instruct *));

	   if (InstructionList == NULL) Fail("Out of memory");
	   }

	InstructionList[c_iptr++] = in;
	}

instruct *
PopInstruction()
	{
	instruct *ptr;

	if (!c_iptr) Fail("Instruction list is empty");

	ptr = InstructionList[--c_iptr];
	InstructionList[c_iptr] = NULL;
	return ptr;
	}

void
FreeInstruction(instruct *in)
	{
	int i;

	for(i=0; i<in->nargs; ++i) switch(in->arg[i].loc)
	   {
	   case 'g':
	   case 't':
	   case 'q': free(in->arg[i].x.str); break;
	   }
	free(in);
	}

instruct *
PeekInstruction(int offset)
	{
	if (offset<0) offset = c_iptr + offset;

	if (offset<0 || offset>=c_iptr) Fail("PeekInstruction: invalid offset %d (c_iptr=%d, m_iptr=%d)",
			offset,c_iptr,m_iptr);
	return InstructionList[offset];
	}

void
FlushInstructionBuffer()
	{
	int i;

	for(i=0; i<c_iptr; ++i)
	   {
	   WriteInstruction(InstructionList[i]);
	   FreeInstruction(InstructionList[i]);
	   }
	free(InstructionList); InstructionList = NULL;
	c_iptr = m_iptr = chp = 0;
	}

void
CheckpointInstructionBuffer()
	{
	if (chp==255) Fail("Internal stack overflow");
	checkpoint[chp++] = c_iptr;
	}

void
RollbackInstructionBuffer()
	{
	if (!chp) Fail("RollbackInstructionBuffer() invalid");

	c_iptr = checkpoint[--chp];
	}

void
WriteInstruction(instruct *in)
	{
	int i;

	switch(in->opcode)
	   {
	   case OP_ADD: printf("\tadd "); break;
	   case OP_SUB: printf("\tsub "); break;
	   case OP_DIV: printf("\tdiv "); break;
	   case OP_MUL: printf("\tmul "); break;
	   case OP_PUSH: printf("\tpush "); break;
	   case OP_STORE: printf("\tstore "); break;
	   case OP_ADECL: printf("\tarray "); break;
	   case OP_FETCH: printf("\tfetch "); break;
	   case OP_GLOBAL: printf(".global\n"); return; break;
	   case OP_TYPES: printf(".types\n"); return; break;
	   case OP_FUNC: printf(".func\t%s\n",in->arg[0].x.str); return; break;
	   case OP_LABEL: printf(".%s\t",in->arg[0].x.str); break;
	   default: printf("?? [%d]\n",in->opcode); return; break;
	   }

	for(i=0; i<in->nargs; ++i)
	   {
	   if (i) printf(",");

	   switch(in->arg[i].loc)
	      	{
	      	case LOC_TOS: printf("@",in->arg[i].x.val); break;
		case LOC_CHAR:
	      	case LOC_INTEGER: printf("$%d",in->arg[i].x.val); break;
	      	case LOC_REAL: printf("$%g",in->arg[i].x.rval); break;
	      	case LOC_STACK: printf("SP%+d",in->arg[i].x.val); break;
	      	case LOC_GLOBAL: printf("_%s",in->arg[i].x.str); break;
		case LOC_STRING: printf("\"%s\"",in->arg[i].x.str); break;
		case LOC_TYPE: printf("%s",in->arg[i].x.str); break;
		case LOC_SIZE_TYPE: printf("$%s",in->arg[i].x.str); break;
		default: printf("[%d: unknown LOC]",in->arg[i].loc); break;
		}
	   }
	printf("\n");
	}
	
/*****************************************************************************/

char *
Expression2(char *p1, char *p2)
	{
	return p1;
	}

char *
Expression3(char *p1, char *p2, char *p3)
	{
	char exprtype[32];

	CalculateExpressionType(p1,p3,exprtype);
	
	return p1;
	}

void
CalculateExpressionType(char *ex1, char *ex2, char *rval)
	{
	if (!strcmp(ex1,"int") && !strcmp(ex2,"int"))
		strcpy(rval,"int");
	else if (!strcmp(ex1,"real") || !strcmp(ex2,"real"))
		strcpy(rval,"real");
	else strcpy(rval,"int");
	}
