#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#define GLOBAL		1
#define LOCAL		2
#define MAYBE_LOCAL	3

#define HEAPSIZE (4 * 1024)

int command(char *,...);
int Fail(char *,...);
char *FindSymbol(int table, char *sym);
int NewTable(void);
int FreeTable(int);
int PushSymbol(int , char *, ...);
void ReplaceSymbol(int,int,char *);
int PopSymbols(int, int);
void DumpTable(int);
void DumpTables(void);
void GetReturnVal(int,char *, char *);
int GetSymData(int, char *, int, char *);
int CopySymbols(int,int,int);
void PushInt(int);
int PopInt(void);
void PushString(char *);
void PopString(char *);
int NumSymbols(int);
void DeclareVariable(int,char *, char *,int);
int GetVariable(int,int,char *, char *, int *);
void SetVariableLocation(int,int,int);
int GetVariableLocation(int,int);
int CheckParameters(char *, int);
int GetField(char *,int, char *);
int GetTypeSize(char *);
void WriteGlobals(void);
void WriteTypes(void);
int LocateStructElement(char *, char *, char *, int *, int *);

extern int t_table;	/* current type table */
extern int gt_table;	/* global type table */
extern int v_table;	/* current variable table */
extern int gv_table;	/* global variable table */
extern int p_table;	/* current prototype table */
extern int gp_table;	/* global prototype table */

extern char funcname[],functype[],dimdef[];
extern int LineNum;
extern char Heap[];
extern int StackPointer,scope,HeapOffset;;

/***************************************************************************
**
** Opcodes
**
****************************************************************************/

#define OP_PUSH		1
#define OP_ADECL	2
#define OP_FETCH	3
#define OP_ADD		4
#define OP_SUB		5
#define OP_MUL		6
#define OP_DIV		7
#define OP_STORE	8

#define OP_GLOBAL	128
#define OP_TYPES	129
#define OP_LABEL	131
#define OP_FUNC		132

#define LOC_TOS		1
#define LOC_STACK	2
#define LOC_GLOBAL	3
#define LOC_INTEGER	4
#define LOC_REAL 	5
#define LOC_CHAR 	6
#define LOC_STRING 	7
#define LOC_TYPE	8
#define LOC_SIZE_TYPE	9

#define MAX_ARGS 	5

typedef struct
	{
	int opcode;
	int nargs;
	struct
	   {
	   int loc;
	   union
	   	{
	   	char *str;
		int val;
		double rval;
		} x;
	   } arg[MAX_ARGS];
	} instruct;

/*
** Instruct.c
*/
char *Expression2(char *, char *);
char *Expression3(char *, char *, char *);
instruct * BuildInstruction(int,int,char *,...);
void PushInstruction(instruct *);
instruct * PopInstruction(void);
void FreeInstruction(instruct *);
instruct *PeekInstruction(int);
void FlushInstructionBuffer(void);
void CheckpointInstructionBuffer(void);
void RollbackInstructionBuffer(void);
void WriteInstruction(instruct *);
