#include <parse.h>

/*
** This module contains the heap management routines.
**
** The external functions are:
**	_hmalloc(size)
**	_hrealloc(size)
**	_hfree(ptr)
*/

static int heap_init=0;

typedef struct hstruct
	{
	struct hstruct *next, *prev;
	int size;
	char *data;
	} HeapEntry;

HeapEntry *FreeList;

static HeapEntry *
NewHeapEntry()
	{
	HeapEntry *h;

	h = (HeapEntry *)malloc(sizeof(HeapEntry);
	if (h==NULL) Fail("Out of Memory");
	h->next = h->prev=NULL;
	h->data = Heap;
	h->size=0;
	return h;
	}

static void
HeapInit()
	{
	FreeList = NewHeapEntry();
	FreeList->size = HEAPSIZE;
	heap_init=1;
	}

/*************************************************************************/

char *
_hmalloc(int size)
	{
	HeapEntry *h,*best;

	if (!heap_init) HeapInit();

	/*
	** Look through the Freelist for a free block which is closest in
	** size to the required size.
	*/
	best = h = FreeList;
	while(h)
	   {
	   if (h->size >= size && h->size<best->size) best=h;
	   h=h->next;
	   }
	}
char *
_hrealloc(char *hptr, int size)
	{
	if (!heap_init) HeapInit();
	}

void
_hfree(char *hptr)
	{
	if (!heap_init) Fail("Called _hfree with invalid pointer");
	}
