#include "parse.h"

int StackPointer;
char funcname[32];
int LineNum=1;
char Heap[HEAPSIZE];
int HeapOffset=0;

yyerror(char *msg)
	{
	fprintf(stderr,"YYERROR: %s\n",msg);
	fflush(stderr);
	}

Fail(char *format, ...)
	{
	va_list arg;
	char msg[2048];

	va_start(arg,format);
	vsprintf(msg,format,arg);
	printf("Line %d: %s\n",LineNum,msg); fflush(stdout);
DumpTables();
	exit(1);
	}

command(char *format, ...)
	{
	va_list arg;
	char msg[2048];

	va_start(arg,format);
	vsprintf(msg,format,arg);
	printf("%s\n",msg); fflush(stdout);
	va_end(arg);
	}

int p_table,gp_table;		/* function prototypes */
int t_table,gt_table;		/* global type table */
int v_table,gv_table;		/* variables */

main()
	{
	gp_table = NewTable();
	gt_table = NewTable();
	gv_table = NewTable();

	t_table = gt_table;
	PushSymbol(t_table,"int:int:0:4");
	PushSymbol(t_table,"real:real:0:8");
	PushSymbol(t_table,"char:char:0:1");

	v_table = gv_table;
	p_table = gp_table;

	StackPointer=0; dimdef[0]=0;
	OutputInstruction(".code");
	yyparse();
	/*WriteTypes();*/
	WriteGlobals();
	FlushInstructionBuffer();
	}
