%{
#include "parse.h"

#define NONE		1
#define DECL		2
#define PROTO		3
#define FUNC_HDR	5

int state = NONE, scope = GLOBAL;
int found_type=0, struct_element=0;
char cur_name[32],func_name[32],decl_type[32];
char var_type[32];
char dimdef[32];
%}

%union {
	int ival;
	double dval;
	char symname[32];
	char string[2048];
	}


%token		ADDEQ SUBEQ MULEQ DIVEQ MODEQ ANDEQ BOREQ BANDEQ XOREQ AND OR
%token		IF ELSE WHILE GOTO FOR STRUCT
%token 		SHLEQ SHREQ EQ GEQ LEQ NEQ
%token <symname>NAME TYPE QSTRING INC DEC
%token <string>	REAL INTEGER
%token <ival>  	QCHAR

%nonassoc LOWER_THAN_ELSE
%nonassoc ELSE

%left EQ NEQ
%left '-' '+'
%left LSHIFT RSHIFT '>' '<' GEQ LEQ
%left '*' '/'
%left '&' '|' '^'
%nonassoc UMINUS INC DEC
%left '.'

%type <symname> label expression vname
%type <symname> exprlist type var simple_var function func_decl
%type <symname> name increment decrement func_call qchar
%type <string>  qstring
%type <ival>	dimensions imm_type
%%

program:	program_element
		| program program_element
		;
		

program_element: declaration
		| function		{}
		| type_decl
		| prototype
		;

type_decl:	struct '{' declarations '}' NAME end	{
				char tmp[256],tmp1[256],rval[64],ty[32],nam[32];
				int i,n,dim;

				n = NumSymbols(v_table);
				sprintf(tmp,"%s:struct:%d",$5,n);
				for(i=0; i<n; ++i)
				   {
				   GetVariable(v_table,i,nam,ty,&dim);
				   sprintf(tmp1,":%s:%s:%d",ty,nam,dim);
				   strcat(tmp,tmp1);
				   }
				scope = PopInt();
				FreeTable(v_table); v_table = PopInt();
				PushSymbol(t_table,tmp);
				}
		;

name:		NAME	{strcpy($$,$1); strcpy(cur_name,$1);}
		;

imm_type:	TYPE	{printf("Imm type %s\n",$1);}
		;

type:		TYPE	{strcpy($$,$1); strcpy(decl_type,$1); found_type=1;}
		;
struct:		STRUCT	{
			PushInt(v_table);
			v_table=NewTable();
			PushInt(scope);
			scope = IN_STRUCT;
			}
		;

increment:	INC	{strcpy($$,$1);}
		;

decrement:	DEC	{strcpy($$,$1);}
		;


end:	';'	{found_type=0; }

declarations:	declaration
		| declaration declarations
		;

declaration:	type var_list end	{ }
		;

function: 	type func_decl fstart func_body fend {strcpy($$,$2);}
		;

prototype:	type func_decl end {
				char tmp[256],tmp1[256],rval[64],ty[32],nam[32];
				int i,n,dim;

				n = NumSymbols(v_table);
				sprintf(tmp,"%s:%s:%d",$2,$1,n);
				for(i=0; i<n; ++i)
				   {
				   GetVariable(v_table,i,nam,ty,&dim);
				   sprintf(tmp1,":%s:%s:%d",ty,nam,dim);
				   strcat(tmp,tmp1);
				   }
				StackPointer = PopInt(); /* forget declarations */
				FreeTable(v_table); v_table = PopInt();
				PushSymbol(p_table,tmp);
				scope=GLOBAL;
				RollbackInstructionBuffer();
				}
		;

func_decl:	name obracket func_params ')'	{strcpy($$,$1);}
		;

obracket:	'('	{
			CheckpointInstructionBuffer();
			PushInt(v_table);
			v_table = NewTable();
			strcpy(func_name,cur_name);
			scope=MAYBE_LOCAL;
			/* If this is a prototype, then we will have to roll back */
			PushInt(StackPointer);
			OutputInstruction("\tcheckpoint");
			}
		;

fstart:		'{'	{
			scope=LOCAL;
			/* Checks type against prototype & declares locals */
			CheckParameters(func_name,v_table);
			StackPointer=0;

			CopySymbols(gv_table,v_table,0);
			OutputInstruction(".func\t%s",func_name);
			}

fend:		'}'	{
			DumpTable(v_table);
			FreeTable(v_table);
			StackPointer = PopInt();
			v_table = PopInt();
			scope=GLOBAL;
			OutputInstruction("\trollback");
			}
		;

func_params:	func_params ',' func_param
		| func_param
		;

func_param:	type 			{
					DeclareVariable(v_table,$1,NULL,0);
					}
		| type NAME		{
					DeclareVariable(v_table,$1,$2,0);
					}
		| type NAME dimensions 	{
					DeclareVariable(v_table,$1,$2,$3);
					}
		|
		;

func_body:	declarations func_elements
		| declarations
		| func_elements
		;

func_elements:	func_element			{}
		| func_elements func_element
		;

func_element:	statement
		| if_construct
		| while_construct
		| for_construct
		| goto_construct
		| label				{}
		;

statement: 	assignment end			{}
		;

assignment:	var '=' expression 		{}
		| var ADDEQ expression  	{}
		| var SUBEQ expression  	{}
		| var MULEQ expression  	{}
		| var DIVEQ expression  	{}
		| var MODEQ expression  	{}
		| var ANDEQ expression  	{}
		| var BOREQ expression  	{}
		| var BANDEQ expression 	{}
		| var XOREQ expression  	{}
		| var SHLEQ expression  	{}
		| var SHREQ expression  	{}
		| expression			{}
		;


expression:	expression '+' expression	{strcpy($$,Expression3($1,"+",$3));}
		| expression '-' expression	{strcpy($$,Expression3($1,"-",$3));}
		| expression '*' expression	{strcpy($$,Expression3($1,"*",$3));}
		| expression '/' expression 	{strcpy($$,Expression3($1,"/",$3));}
		| expression '&' expression 	{strcpy($$,Expression3($1,"&",$3));}
		| expression '|' expression 	{strcpy($$,Expression3($1,"|",$3));}
		| expression '^' expression 	{strcpy($$,Expression3($1,"^",$3));}
		| expression '>' expression 	{strcpy($$,Expression3($1,">",$3));}
		| expression '<' expression 	{strcpy($$,Expression3($1,"<",$3));}
		| expression EQ expression	{strcpy($$,Expression3($1,"==",$3));}
		| expression NEQ expression	{strcpy($$,Expression3($1,"!=",$3));}
		| expression GEQ expression	{strcpy($$,Expression3($1,">=",$3));}
		| expression LEQ expression	{strcpy($$,Expression3($1,"<=",$3));}
		| expression LSHIFT expression 	{strcpy($$,Expression3($1,"<<",$3));}
		| expression RSHIFT expression 	{strcpy($$,Expression3($1,">>",$3));}
		| '~' expression %prec UMINUS	{strcpy($$,Expression2("~",$2));}
		| '-' expression %prec UMINUS	{strcpy($$,Expression2("-",$2));}
		| increment var			{strcpy($$,Expression2("++",$2));}
		| decrement var			{strcpy($$,Expression2("--",$2));}
		| var increment			{strcpy($$,Expression2($1,"++"));}
		| var decrement			{strcpy($$,Expression2($1,"--"));}
		| REAL				{DeclareReal($1); strcpy($$,"real 0");}
		| INTEGER			{DeclareInt($1); strcpy($$,"int 0");}
		| qstring			{strcpy($$,$1);}
		| qchar				{strcpy($$,$1);}
		| var				{strcpy($$,$1); struct_element=0;}
		| func_call			{strcpy($$,$1);}
		;

qstring:	QSTRING			{strcpy($$,"char 1");}
		;

qchar:		QCHAR			{strcpy($$,"char 0");}
		;

var_list:	var_list ',' var		{}
		| var				{}
		;

var: 	simple_var dot var	{
				int found,i,offset,nelem;
				char *data,rval[32];

printf("[%s] . [%s]\n",$1,$3);
				OutputInstruction("\tpop struct type %s",$1);
				data = FindSymbol(t_table,$1);
				if (data==NULL) Fail("Unknown type: %s",$1);
				GetField(data,1,rval); if (strcmp(rval,"struct"))
					Fail("%s is not a struct",$1);
				GetField(data,2,rval); nelem = atoi(rval);
				for(i=found=offset=0; !found && i<nelem; ++i)
					{
					GetField(data,4+3*i,rval);
					if (!strcmp(rval,$3)) found=1;
					else
					   {
					   GetField(data,3+3*i,rval);
					   offset += GetTypeSize(rval);
					   }
					}
				if (!found) Fail("%s is not an element of this struct",$3);
				OutputInstruction("\tpush element %s at offset %d",rval,offset);
				GetField(data,3+3*i,$$);
				}
	| '(' imm_type exprlist ')'	{
				if (found_type) Fail("Immediate struct invalid in declaration");
				}
	| simple_var			{}
	;

simple_var: vname dimensions 	{

printf("vname dims state=%d found_type=%d\n",state,found_type);
				if (found_type && state != IN_SQUARE)
				   {
				   DeclareVariable(v_table,decl_type,$1,$2);
				   strcpy($$,decl_type);
				   }
				else
				   {
				   char tmp[64];
				   char *data,rval[32];
				   int ndims;

/*HERE */
				   data = FindSymbol(v_table,$1);
				   if (data==NULL) Fail("Undefined variable %s",$1);
				   GetField(data,2,rval); ndims=atoi(rval);
				   if ($2 > ndims) Fail("Array access to scalar variable");

				   OutputInstruction("\tfetch element dim %d\n",$2);
				   StackPointer -= 4 * $2; /* remove args */
				   StackPointer -= 4;	   /* remove base address */

				   if ($2 == ndims) GetField(data,1,var_type);
				   strcpy($$,var_type);

				   StackPointer += GetTypeSize(var_type);
printf("name dimensions: type = %s\n",var_type);
				   }
				}
	   | vname		{
				char *data,type[32],rval[32],*typestr,*pref;
				int ndims;

				if (struct_element) strcpy($$,$1);
				else if (found_type && state != IN_SQUARE)
				   {
				   DeclareVariable(v_table,decl_type,$1,0);
				   strcpy($$,decl_type);
				   }
				else strcpy($$,var_type);
				}
	;

vname:	NAME	{
		char *pref,*data,rval[32];;

		if (struct_element) strcpy($$,$1);
		else if (found_type==0 || state==IN_SQUARE)
		   {
		   /* The variable is part of an expression, not a declaration */
		   data = FindSymbol(v_table,$1);
		   if (data==NULL) Fail("%s: Unknown variable",$1);
		   GetField(data,2,rval);
		   if (atoi(rval)>0) strcpy(var_type,"ptr "); else var_type[0]=0;
		   GetField(data,1,rval); strcat(var_type,rval);

		   GetField(data,3,rval);
		   if (rval[0]=='s') pref="stack"; else pref="";
		   OutputInstruction("\tpush %s (%s%+d)",
				var_type,pref,atoi(rval+1));
		   StackPointer += GetTypeSize(var_type);
		   }
		else strcpy($$,$1);}
		;

dimensions:	dimensions dim		{ $$++;}
		| dim			{ $$=1;}
		;

dim:		osquare expression csquare	{}
		| osquare csquare		{if (!found_type)
						   Fail("Empty [] in expression");
					}
		;

osquare:	'['	{PushString(var_type); var_type[0]=0;
			 PushInt(state); state = IN_SQUARE;
			 PushInt(struct_element); struct_element=0;} 	;
csquare:	']'	{struct_element = PopInt();
			 state = PopInt(); PopString(var_type);};

dot:	'.'				{struct_element=1;}
		;

func_call:	NAME '(' exprlist ')'	{}
		;

exprlist:	exprlist ',' expression		{}
		| expression			{}
		;

basic_if:	IF '(' expression ')' block 	{}
		;

if_construct:	basic_if %prec LOWER_THAN_ELSE	{}
		| basic_if ELSE block		{}
		;

while_construct: WHILE '(' expression ')' block	{}
		;

for_construct:	FOR '(' list ';' expression ';' list ')' block {}
		;

list:	list ',' assignment		{}
	| assignment			{}
		;

goto_construct:	GOTO NAME ';'			{}
		;

block:		func_element
		| bstart func_body bend
		;


bstart:		'{'	{
			OutputInstruction("\tcheckpoint");
			PushInt(StackPointer);
			PushInt(NumSymbols(v_table));
			}
		;

bend:		'}'	{
			int n;

			n = NumSymbols(v_table) - PopInt();
			if (n>0) PopSymbols(v_table,n);

			StackPointer = PopInt();
			OutputInstruction("\trollback");
			}
		;

label:		NAME ':'	{}
%%

int
CheckOp(char *p1, char *p2, char *t1, char *t2, char *opcode, char *rval, char *rt)
	{
	if (!strcmp(p1,t1) && !strcmp(p2,t2))
	   {
	   if (opcode) OutputInstruction(opcode);
	   if (rval) strcpy(rval,rt);
	   return 1;
	   }
	return 0;
	}

int
Cast(char *ex1, int op, char *ex2)
	{
	if (!strcmp(ex1,ex2)) return 0;

printf("cast %s <- %s\n",ex1,ex2);
	switch(op)
	   {
	   case '=': if (
		CheckOp(ex1,ex2,"int","real","CASTRI",NULL,NULL) ||
		CheckOp(ex1,ex2,"real","int","CASTRI",NULL,NULL) ||
		CheckOp(ex1,ex2,"string","int","CASTSI",NULL,NULL) ||
		CheckOp(ex1,ex2,"string","real","CASTRI",NULL,NULL)
		); else Fail("%s+%s: Invalid type conversion requested",ex1,ex2);
		break;
	   }
	return 0;
	}
