%{
#include "y.tab.h"
#include <math.h>
#include "parse.h"

%}

%%

"+="	return ADDEQ;
"-="	return SUBEQ;
"*="	return MULEQ;
"/="	return DIVEQ;
"%="	return MODEQ;
"&="	return BANDEQ;
"|="	return BOREQ;
"^="	return XOREQ;
"<<"	return LSHIFT;
">>"	return RSHIFT;
"&&"	return AND;
"||"	return OR;
"=="	return EQ;
">="	return GEQ;
"<="	return LEQ;
"!="	return NEQ;
"++"	{printf("[INC]\n"); return INC;}
"--"	return DEC;
"%%"	{DumpTables();}

"<<="	return SHLEQ;
">>="	return SHREQ;
[0-9]+	{ yylval.ival = atoi(yytext); return INTEGER;}

[0-9]*(\.[0-9]+)([eE][+-]?[0-9]+)? {
	yylval.dval = atof(yytext);
	return REAL;
	}

"if"	return IF;
"else"	return ELSE;
"for"	return FOR;
"goto"	return GOTO;
"while" return WHILE;
"struct"  return STRUCT;

[ \t]+ ;		/* ignore whitespace */

[\n\r]	 ++LineNum;

[a-zA-Z_]([a-zA-Z0-9_])*	{strncpy(yylval.symname,yytext,31); 
			yylval.symname[31]=0;
			if (FindSymbol(t_table,yytext)) return TYPE;
			return NAME;
			}
\'\\[0-9a-fA-Fx]+\' {
		int i,len;

		len=strlen(yytext); yytext[len-1]=0;
		for(i=0; yytext[i+1]; ++i) yytext[i]=yytext[i+2];
		if (yytext[1]==0)
	    	   {
	    	   switch(yytext[0])
			{
			case 'n': yylval.ival='\n'; break;
			case 'r': yylval.ival='\r'; break;
			case 't': yylval.ival='\t'; break;
			case 'f': yylval.ival='\f'; break;
			}
	    	   return QCHAR;
	    	   }
	   	if (yytext[0]=='0')
		   {
		   yylval.ival = strtol(yytext,(char **)NULL,0);
		   return QCHAR;
		   }
	   	Fail("Lex: Invalid character %s\n",yytext);
	   	}

\".*\"	{strcpy(yylval.string,yytext); return QSTRING;}
\'.\'		{yylval.ival = yytext[1]; return QCHAR;}

. 	{ return yytext[0];}

%%

#ifdef USE_MAIN

YYSTYPE yylval;

main()
	{
	while(yylex()) printf("[%s]\n",yytext);
	}
#endif
