%{
#include "parse.h"

#define NONE		1
#define DECL		2
#define PROTO		3
#define FUNC_HDR	5

#define GLOBAL		1
#define LOCAL		2

int state = NONE, scope = GLOBAL;
int found_type=0;
char cur_type[32],cur_name[32],func_name[32];
%}

%union {
	int ival;
	double dval;
	char symname[32];
	char string[2048];
	}


%token		ADDEQ SUBEQ MULEQ DIVEQ MODEQ ANDEQ BOREQ BANDEQ XOREQ AND OR
%token		IF ELSE WHILE GOTO FOR STRUCT
%token 		SHLEQ SHREQ EQ GEQ LEQ NEQ
%token <symname>NAME TYPE QSTRING INC DEC
%token <dval>  	REAL
%token <ival>  	INTEGER QCHAR

%nonassoc LOWER_THAN_ELSE
%nonassoc ELSE

%left EQ NEQ
%left '-' '+'
%left LSHIFT RSHIFT '>' '<' GEQ LEQ
%left '*' '/'
%left '&' '|' '^'
%nonassoc UMINUS INC DEC
%left '.'

%type <symname> label expression
%type <symname> exprlist type var simple_var function func_decl
%type <symname> name increment decrement func_call qchar
%type <string>  qstring
%type <ival>	dimensions imm_type
%%

program:	program_element
		| program program_element
		;
		

program_element: declaration
		| function		{}
		| prototype
		;

name:		NAME	{strcpy($$,$1); strcpy(cur_name,$1);}
		;

imm_type:	TYPE	{printf("Imm type %s\n",$1);}
		;

type:		TYPE	{strcpy($$,$1); strcpy(cur_type,$1); found_type=1;}
		;
struct:		STRUCT	{
			PushInt(v_table);
			v_table=NewTable();
			}
		;

increment:	INC	{strcpy($$,$1);}
		;

decrement:	DEC	{strcpy($$,$1);}
		;


end:	';'	{found_type=0; }

declarations:	declaration
		| declaration declarations
		;

declaration:	type var_list end	{ }
		| struct '{' declarations '}' NAME end	{
				char tmp[256],tmp1[256],rval[64],ty[32],nam[32];
				int i,n,dim;

				n = NumSymbols(v_table);
				sprintf(tmp,"%s:struct:%d",$5,n);
				for(i=0; i<n; ++i)
				   {
				   GetVariable(v_table,i,nam,ty,&dim);
				   sprintf(tmp1,":%s:%s:%d",ty,nam,dim);
				   strcat(tmp,tmp1);
				   }
				FreeTable(v_table); v_table = PopInt();
				PushSymbol(t_table,tmp);
				}
		;

function: 	type func_decl fstart func_body fend {strcpy($$,$2);}
		;

prototype:	type func_decl end {
				char tmp[256],tmp1[256],rval[64],ty[32],nam[32];
				int i,n,dim;

				n = NumSymbols(v_table);
				sprintf(tmp,"%s:%s:%d",$2,$1,n);
				for(i=0; i<n; ++i)
				   {
				   GetVariable(v_table,i,nam,ty,&dim);
				   sprintf(tmp1,":%s:%s:%d",ty,nam,dim);
				   strcat(tmp,tmp1);
				   }
				FreeTable(v_table); v_table = PopInt();
				PushSymbol(p_table,tmp);
DumpTable(p_table);
				}
		;

func_decl:	name obracket func_params ')'	{strcpy($$,$1);}
		;

obracket:	'('	{
			PushInt(v_table);
			v_table = NewTable();
			strcpy(func_name,cur_name);
			}
		;

fstart:		'{'	{
			t_table = NewTable();
			CopySymbols(gt_table,t_table,0);

			CheckParameters(func_name,v_table);

			CopySymbols(gv_table,v_table,0);
			}

fend:		'}'	{
			FreeTable(t_table);
			t_table = gt_table;
			FreeTable(v_table);
			v_table = gv_table;
			}
		;

func_params:	func_params ',' func_param
		| func_param
		;

func_param:	type 			{
					DeclareVariable(v_table,$1,NULL,0);
					}
		| type NAME		{
					DeclareVariable(v_table,$1,$2,0);
					}
		| type NAME dimensions 	{
					DeclareVariable(v_table,$1,$2,$3);
					}
		|
		;

func_body:	declarations func_elements
		| declarations
		| func_elements
		;

func_elements:	func_element			{}
		| func_elements func_element
		;

func_element:	statement
		| if_construct
		| while_construct
		| for_construct
		| goto_construct
		| label				{}
		;

statement: 	assignment end			{}
		;

assignment:	var '=' expression 		{}
		| var ADDEQ expression  	{}
		| var SUBEQ expression  	{}
		| var MULEQ expression  	{}
		| var DIVEQ expression  	{}
		| var MODEQ expression  	{}
		| var ANDEQ expression  	{}
		| var BOREQ expression  	{}
		| var BANDEQ expression 	{}
		| var XOREQ expression  	{}
		| var SHLEQ expression  	{}
		| var SHREQ expression  	{}
		| expression			{}
		;


expression:	expression '+' expression	{strcpy($$,Expression3($1,"+",$3));}
		| expression '-' expression	{strcpy($$,Expression3($1,"-",$3));}
		| expression '*' expression	{strcpy($$,Expression3($1,"*",$3));}
		| expression '/' expression 	{strcpy($$,Expression3($1,"/",$3));}
		| expression '&' expression 	{strcpy($$,Expression3($1,"&",$3));}
		| expression '|' expression 	{strcpy($$,Expression3($1,"|",$3));}
		| expression '^' expression 	{strcpy($$,Expression3($1,"^",$3));}
		| expression '>' expression 	{strcpy($$,Expression3($1,">",$3));}
		| expression '<' expression 	{strcpy($$,Expression3($1,"<",$3));}
		| expression EQ expression	{strcpy($$,Expression3($1,"==",$3));}
		| expression NEQ expression	{strcpy($$,Expression3($1,"!=",$3));}
		| expression GEQ expression	{strcpy($$,Expression3($1,">=",$3));}
		| expression LEQ expression	{strcpy($$,Expression3($1,"<=",$3));}
		| expression LSHIFT expression 	{strcpy($$,Expression3($1,"<<",$3));}
		| expression RSHIFT expression 	{strcpy($$,Expression3($1,">>",$3));}
		| '~' expression %prec UMINUS	{strcpy($$,Expression2("~",$2));}
		| '-' expression %prec UMINUS	{strcpy($$,Expression2("-",$2));}
		| increment var			{strcpy($$,Expression2("++",$2));}
		| decrement var			{strcpy($$,Expression2("--",$2));}
		| var increment			{strcpy($$,Expression2($1,"++"));}
		| var decrement			{strcpy($$,Expression2($1,"--"));}
		| REAL				{strcpy($$,"real 0");}
		| INTEGER			{strcpy($$,"int 0");}
		| qstring			{strcpy($$,$1);}
		| qchar				{strcpy($$,$1);}
		| var				{strcpy($$,$1);}
		| func_call			{strcpy($$,$1);}
		;

qstring:	QSTRING			{strcpy($$,"char 1");}
		;

qchar:		QCHAR			{strcpy($$,"char 0");}
		;

var_list:	var_list ',' var		{}
		| var				{}
		;

var: 	var dot simple_var		{
				if (found_type) Fail("struct element invalid in declaration");
				}
	| '(' imm_type exprlist ')'	{
				if (found_type) Fail("Immediate struct invalid in declaration");
				}
	| simple_var			{}
	;

simple_var: NAME dimensions 	{
				if (found_type)
				   DeclareVariable(v_table,cur_type,$1,$2);
				}
	   | NAME		{
				if (found_type)
				   DeclareVariable(v_table,cur_type,$1,0);
				}
	;

dimensions:	dimensions dim		{ $$++;}
		| dim			{ $$=1;}
		;

dim:		'[' expression ']'	{}
		| '[' ']'		{OutputInstruction("PUSH 0");}
		;

dot:	'.'				{}
		;

func_call:	NAME '(' exprlist ')'	{}
		;

exprlist:	exprlist ',' expression		{}
		| expression			{}
		;

basic_if:	IF '(' expression ')' block 	{}
		;

if_construct:	basic_if %prec LOWER_THAN_ELSE	{}
		| basic_if ELSE block		{}
		;

while_construct: WHILE '(' expression ')' block	{}
		;

for_construct:	FOR '(' list ';' expression ';' list ')' block {}
		;

list:	list ',' assignment		{}
	| assignment			{}
		;

goto_construct:	GOTO NAME ';'			{}
		;

block:		func_element
		| bstart func_body bend
		;


bstart:		'{'	{
			PushInt(NumSymbols(v_table));
			PushInt(NumSymbols(t_table));
			}
		;

bend:		'}'	{
			int n;

			n = NumSymbols(t_table) - PopInt();
			if (n>0) PopSymbols(t_table,n);

			n = NumSymbols(v_table) - PopInt();
			if (n>0) PopSymbols(v_table,n);
			}
		;

label:		NAME ':'	{}
%%

int
CheckOp(char *p1, char *p2, char *t1, char *t2, char *opcode, char *rval, char *rt)
	{
	if (!strcmp(p1,t1) && !strcmp(p2,t2))
	   {
	   if (opcode) OutputInstruction(opcode);
	   if (rval) strcpy(rval,rt);
	   return 1;
	   }
	return 0;
	}

int
Cast(char *ex1, int op, char *ex2)
	{
	if (!strcmp(ex1,ex2)) return 0;

printf("cast %s <- %s\n",ex1,ex2);
	switch(op)
	   {
	   case '=': if (
		CheckOp(ex1,ex2,"int","real","CASTRI",NULL,NULL) ||
		CheckOp(ex1,ex2,"real","int","CASTRI",NULL,NULL) ||
		CheckOp(ex1,ex2,"string","int","CASTSI",NULL,NULL) ||
		CheckOp(ex1,ex2,"string","real","CASTRI",NULL,NULL)
		); else Fail("%s+%s: Invalid type conversion requested",ex1,ex2);
		break;
	   }
	return 0;
	}
