%{
#include "parse.h"

#define NONE		1
#define DECL		2
#define PROTO		3
#define FUNC_HDR	5

int state = NONE, scope = GLOBAL;
int found_type=0;
char cur_name[32],func_name[32],decl_type[32];
char var_type[32] = {0};
%}

%union {
	int ival;
	double dval;
	char symname[32];
	char string[2048];
	}


%token		ADDEQ SUBEQ MULEQ DIVEQ MODEQ ANDEQ BOREQ BANDEQ XOREQ AND OR
%token		IF ELSE WHILE GOTO FOR STRUCT
%token 		SHLEQ SHREQ EQ GEQ LEQ NEQ
%token <symname>NAME TYPE QSTRING INC DEC
%token <string>	REAL INTEGER
%token <ival>  	QCHAR

%nonassoc LOWER_THAN_ELSE
%nonassoc ELSE

%left EQ NEQ
%left '-' '+'
%left LSHIFT RSHIFT '>' '<' GEQ LEQ
%left '*' '/'
%left '&' '|' '^'
%nonassoc UMINUS INC DEC
%left '.'

%type <symname> label expression vname
%type <symname> exprlist type var function func_decl
%type <symname> name increment decrement func_call qchar
%type <string>  qstring
%type <ival>	dimensions dim
%%

program:	program_element
		| program program_element
		;
		

program_element: declaration
		| function		{}
		| type_decl
		| prototype
		;

type_decl:	struct '{' declarations '}' NAME end	{
				char tmp[256],tmp1[256],rval[64],ty[32],nam[32];
				int i,n,dim;

				n = NumSymbols(v_table);
				sprintf(tmp,"%s:struct:%d",$5,n);
				for(i=0; i<n; ++i)
				   {
				   GetVariable(v_table,i,nam,ty,&dim);
				   sprintf(tmp1,":%s:%s:%d",ty,nam,dim);
				   strcat(tmp,tmp1);
				   }
				scope = PopInt();
				HeapOffset = PopInt();
				StackPointer = PopInt();
				FreeTable(v_table); v_table = PopInt();
				PushSymbol(t_table,tmp);
				RollbackInstructionBuffer();
				}
		;

name:		NAME	{strcpy($$,$1); strcpy(cur_name,$1);}
		;

type:		TYPE	{strcpy($$,$1); strcpy(decl_type,$1); found_type=1;}
		;
struct:		STRUCT	{
			PushInt(v_table); v_table=NewTable();
			PushInt(StackPointer);
			PushInt(HeapOffset);
			PushInt(scope);
			CheckpointInstructionBuffer();
			}
		;

increment:	INC	{strcpy($$,$1);}
		;

decrement:	DEC	{strcpy($$,$1);}
		;


end:	';'	{found_type=0; }

declarations:	declaration
		| declaration declarations
		;

declaration:	type decl_var_list end	{ }
		;

function: 	type func_decl fstart func_body fend {strcpy($$,$2);}
		;

prototype:	type func_decl end {
				char tmp[256],tmp1[256],rval[64],ty[32],nam[32];
				int i,n,dim;

				n = NumSymbols(v_table);
				sprintf(tmp,"%s:%s:%d",$2,$1,n);
				for(i=0; i<n; ++i)
				   {
				   GetVariable(v_table,i,nam,ty,&dim);
				   sprintf(tmp1,":%s:%s:%d",ty,nam,dim);
				   strcat(tmp,tmp1);
				   }
				StackPointer = PopInt(); /* forget declarations */
				FreeTable(v_table); v_table = PopInt();
				PushSymbol(p_table,tmp);
				scope=GLOBAL;
				RollbackInstructionBuffer();
				}
		;

func_decl:	name obracket func_params ')'	{strcpy($$,$1);}
		;

obracket:	'('	{
			CheckpointInstructionBuffer();
			PushInt(v_table);
			v_table = NewTable();
			strcpy(func_name,cur_name);
			scope=MAYBE_LOCAL;
			/* If this is a prototype, then we will have to roll back */
			PushInt(StackPointer);
			}
		;

fstart:		'{'	{
			instruct *in;

			scope=LOCAL;
			/* Checks type against prototype & declares locals */
			CheckParameters(func_name,v_table);
			StackPointer=0;

			CopySymbols(gv_table,v_table,0);
			RollbackInstructionBuffer();
			in = BuildInstruction(OP_FUNC,1,"g%s",func_name);
			PushInstruction(in);
			}

fend:		'}'	{
			DumpTable(v_table);
			FreeTable(v_table);
			StackPointer = PopInt();
			v_table = PopInt();
			scope=GLOBAL;
			}
		;

func_params:	func_params ',' func_param
		| func_param
		;

func_param:	type 			{
					DeclareVariable(v_table,$1,NULL,0);
					}
		| type NAME		{
					DeclareVariable(v_table,$1,$2,0);
					}
		| type NAME dimensions 	{
					DeclareVariable(v_table,$1,$2,$3);
					}
		|
		;

func_body:	declarations func_elements
		| declarations
		| func_elements
		;

func_elements:	func_element			{}
		| func_elements func_element
		;

func_element:	statement
		| if_construct
		| while_construct
		| for_construct
		| goto_construct
		| label				{}
		;

statement: 	assignment end			{}
		;

assignment:	var '=' expression 		{}
		| var ADDEQ expression  	{}
		| var SUBEQ expression  	{}
		| var MULEQ expression  	{}
		| var DIVEQ expression  	{}
		| var MODEQ expression  	{}
		| var ANDEQ expression  	{}
		| var BOREQ expression  	{}
		| var BANDEQ expression 	{}
		| var XOREQ expression  	{}
		| var SHLEQ expression  	{}
		| var SHREQ expression  	{}
		| expression			{}
		;


expression:	expression '+' expression	{strcpy($$,Expression3($1,"+",$3));}
		| expression '-' expression	{strcpy($$,Expression3($1,"-",$3));}
		| expression '*' expression	{strcpy($$,Expression3($1,"*",$3));}
		| expression '/' expression 	{strcpy($$,Expression3($1,"/",$3));}
		| expression '&' expression 	{strcpy($$,Expression3($1,"&",$3));}
		| expression '|' expression 	{strcpy($$,Expression3($1,"|",$3));}
		| expression '^' expression 	{strcpy($$,Expression3($1,"^",$3));}
		| expression '>' expression 	{strcpy($$,Expression3($1,">",$3));}
		| expression '<' expression 	{strcpy($$,Expression3($1,"<",$3));}
		| expression EQ expression	{strcpy($$,Expression3($1,"==",$3));}
		| expression NEQ expression	{strcpy($$,Expression3($1,"!=",$3));}
		| expression GEQ expression	{strcpy($$,Expression3($1,">=",$3));}
		| expression LEQ expression	{strcpy($$,Expression3($1,"<=",$3));}
		| expression LSHIFT expression 	{strcpy($$,Expression3($1,"<<",$3));}
		| expression RSHIFT expression 	{strcpy($$,Expression3($1,">>",$3));}
		| '~' expression %prec UMINUS	{strcpy($$,Expression2("~",$2));}
		| '-' expression %prec UMINUS	{strcpy($$,Expression2("-",$2));}
		| increment var			{strcpy($$,Expression2("++",$2));}
		| decrement var			{strcpy($$,Expression2("--",$2));}
		| var increment			{strcpy($$,Expression2($1,"++"));}
		| var decrement			{strcpy($$,Expression2($1,"--"));}
		| REAL				{strcpy($$,"real");
						PushInstruction(BuildInstruction(OP_PUSH,1,"r%s",$1));}
		| INTEGER			{strcpy($$,"int");
						printf("found int %s\n",$1);
						PushInstruction(BuildInstruction(OP_PUSH,1,"i%s",$1));}
		| qstring			{strcpy($$,$1);}
		| qchar				{strcpy($$,$1);}
		| var				{strcpy($$,$1);}
		| func_call			{strcpy($$,$1);}
		;

qstring:	QSTRING			{strcpy($$,"char 1");}
		;

qchar:		QCHAR			{strcpy($$,"char 0");}
		;

decl_var_list:	decl_var_list ',' decl_var		{}
		| decl_var				{}
		;

decl_var:	NAME dimensions	{
				if (!found_type) Fail("Invalid Declaration");
				   DeclareVariable(v_table,decl_type,$1,$2);
				   }
		| NAME			{
					if (!found_type) Fail("Invalid declaration");
				   	DeclareVariable(v_table,decl_type,$1,0);
				   	}
		;

var: 	vname				{strcpy($$,$1);}
	| vname modifiers		{strcpy($$,$1);}
	;

modifiers: modifier modifiers
	| modifier
	;

modifier: dim 	{
			char type[32];
			int ndims;
			instruct *in;

			if (sscanf(var_type,"%s %d",type,&ndims) != 2)
			   Fail("Array access to non-array: %s",var_type);

			ndims -= $1;

			if (ndims==0) strcpy(var_type,type);
			else sprintf(var_type,"%s %d",type,ndims);

			in = BuildInstruction(OP_FETCH,5,"@ @ @ i0 i%d",GetTypeSize(var_type));
			PushInstruction(in);
			}
	   | '.' NAME	{
				int offset,size,ndims;
				char type[32];
				instruct *in;

				if (sscanf(var_type,"%s %d",type,&ndims) == 2 && ndims>0)
			   	   Fail("Element requested from pointer");

				if (!LocateStructElement(var_type,$2,type,&offset,&size))
				    	   Fail("%s is not an element of this struct",$2);

				in = PeekInstruction(-1);
				if (in->opcode != OP_FETCH) Fail("Internal Error");
				in->arg[3].x.val = offset;
				in->arg[4].x.val = size;
				strcpy(var_type,type);
				}
	;

vname:	NAME	{
		char tmp[128],*data,rval[32];
		instruct *in;

		data = FindSymbol(v_table,$1);
		if (data==NULL) Fail("%s: Unknown variable",$1);
		GetField(data,1,var_type);
		GetField(data,2,rval);
		if (atoi(rval)>0) {strcat(var_type," "); strcat(var_type,rval);}

		GetField(data,3,rval);
		strcpy(tmp,rval); if (tmp[0]=='h') tmp[0]='g';
		in = BuildInstruction(OP_PUSH,1,tmp); PushInstruction(in);
		strcpy($$,var_type);
printf("variable %s type [%s]\n",$1,var_type);
		}
		;

dimensions:	dimensions dim		{ $$+=$1;}
		| dim			{ $$=$1;}
		;

dim:		osquare expression csquare	{$$=1; printf("dim\n");}
		| osquare csquare		{$$=1;
						if (!found_type)
						   Fail("Empty [] in expression");
					}
		;

osquare:	'['	{PushString(var_type); var_type[0]=0;};
csquare:	']'	{PopString(var_type);};

func_call:	NAME '(' exprlist ')'	{}
		;

exprlist:	exprlist ',' expression		{}
		| expression			{}
		;

basic_if:	IF '(' expression ')' block 	{}
		;

if_construct:	basic_if %prec LOWER_THAN_ELSE	{}
		| basic_if ELSE block		{}
		;

while_construct: WHILE '(' expression ')' block	{}
		;

for_construct:	FOR '(' list ';' expression ';' list ')' block {}
		;

list:	list ',' assignment		{}
	| assignment			{}
		;

goto_construct:	GOTO NAME ';'			{}
		;

block:		func_element
		| bstart func_body bend
		;


bstart:		'{'	{
			PushInt(StackPointer);
			PushInt(NumSymbols(v_table));
			}
		;

bend:		'}'	{
			int n;

			n = NumSymbols(v_table) - PopInt();
			if (n>0) PopSymbols(v_table,n);

			StackPointer = PopInt();
			}
		;

label:		NAME ':'	{}
%%

int
CheckOp(char *p1, char *p2, char *t1, char *t2, char *opcode, char *rval, char *rt)
	{
	if (!strcmp(p1,t1) && !strcmp(p2,t2))
	   {
	   if (rval) strcpy(rval,rt);
	   return 1;
	   }
	return 0;
	}

int
Cast(char *ex1, int op, char *ex2)
	{
	if (!strcmp(ex1,ex2)) return 0;

printf("cast %s <- %s\n",ex1,ex2);
	switch(op)
	   {
	   case '=': if (
		CheckOp(ex1,ex2,"int","real","CASTRI",NULL,NULL) ||
		CheckOp(ex1,ex2,"real","int","CASTRI",NULL,NULL) ||
		CheckOp(ex1,ex2,"string","int","CASTSI",NULL,NULL) ||
		CheckOp(ex1,ex2,"string","real","CASTRI",NULL,NULL)
		); else Fail("%s+%s: Invalid type conversion requested",ex1,ex2);
		break;
	   }
	return 0;
	}
