#include <stdio.h>
#include <stdlib.h>

/*
** Tools.c
*/
void Die(char *, ...);
void Log(char *, ...);
int Random(int);
int OneIn(int);
int Overlap_p(int,int,int,int, int,int,int,int);
int Overlap_c(int,int,int,int, int,int,int,int, int *,int *,int *,int *);
int filelength(int);

/*
** Terrain.c
*/
int Create_Terrain(char *);
unsigned int Get_Terrain(int, int);
int Set_Terrain(int,int,unsigned int);
int Set_TerrainTypeIndex(int,int,unsigned,int);
int Load_Terrain(char *);
int Close_Terrain(void);

/*
** Graphics.c
*/
GrObject *GetTile(int which, int var, int *,int *,int *, int *);
int BaseTileForTerrain(int,int,int);
int InitGraphics(void);
int ShutdownGraphics(void);
int GrKeyPress(int *);
int GrWaitforKeyPress(void);
GrObject *GetScreenContext(void);
GrObject *GetMapContext(void);
int NumVarTiles(int);
int RandomTileVariant(int);
int GetColour(int);
int ClearMap(void);
int GLeft(int);
int GRight(int);
int GUp(int);
int GDown(int);
int RedrawMap(void);
int MapText(char *, int,int);

/*
** Plate.c
*/
void InitPlates(void);
void DrawCell(int,int,int,int);
void MapScroll(int,int);
int MapRefresh(void);
void InvalidatePlates(int,int,int,int);
void InvalidateAllPlates(void);
void DrawImage(GrObject *src, int dx, int dy, int,int,int,int, int op);
void GetMapSubSection(GrObject *dst, int dx, int dy, int,int,int,int);
void RedrawMapSubSection(int,int,int,int);

/*
** Gif.c
*/
GrObject *LoadGif(char *);
int WritePPMfromGif(int, char *);
int NumImages(void);
void GifMapColourToBg(GrObject *, int);

/*
** Display.c
*/
void SetMapCentre(int,int);
void GetMapCentre(int *, int *);
void ScrollMapCentre(int,int);
int RedrawMap(void);
void InvalidateRegion(int,int,int,int);
void ResetRegions(void);
void RedrawRegions(void);

/*
** text.c
*/
void GrSetTextRegion(int,int,int,int);
int Print(int,int,char *, ...);
int TextInit(void);
void RefreshText(void);

/*
** Trig.c
*/
double sine(int);
double cosine(int);

/*
** flib/Features.c
*/
int iswater(int,int);
void Create_Landscape(void);

/*
** flib/Lakes.c
*/
void create_lakes(void);
void create_lake(int,int,int);

/*
** flib/River.c
*/
void River(int,int,int,int);

/*
** flib/Swamp.c
*/
void create_swamp(void);

/*
** Sprite.c
*/
int GetSpriteID(char *);
int LoadSprites(char *name);
int CreateEntity(int SpriteID, int StartFrame, int x, int y, int p);
void UpdateEntities(int,int,int,int);
int RemoveEntity(int eid);
unsigned short *GetSpriteData(int,int);
void SetSpritePixel(int,int,int,int,int);
void MoveEntity(int eid, int dx, int dy, int flags);
